/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.seat.warpper;

import android.content.Context;
import android.graphics.Point;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.radio.seat.RadioSeatPresenter;
import com.yy.hiyo.channel.plugins.radio.seat.view.RadioSeatView;
import com.yy.hiyo.channel.plugins.radio.seat.warpper.BaseRadioSeatViewWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RadioSeatViewWrapper
extends BaseRadioSeatViewWrapper {
    private RadioSeatView mSeatView;
    private RadioSeatPresenter.OnClickChannelOwnerListener mListener;
    private boolean isSupportReuse = false;

    public RadioSeatViewWrapper(RadioSeatPresenter.OnClickChannelOwnerListener listener2, IEnteredChannel channel, RadioSeatPresenter.OnAnchorSeatChangedListener onAnchorSeatChangedListener, boolean isSupportReuse) {
        super(onAnchorSeatChangedListener, channel);
        this.mListener = listener2;
        this.isSupportReuse = isSupportReuse;
    }

    @Override
    public void createView(Context context, ViewGroup parent) {
        if (null == this.mSeatView) {
            this.mSeatView = new RadioSeatView(context, this, this.mListener, (IChannel)this.mChannel);
        } else {
            if (null != this.mSeatView.getParent()) {
                ((ViewGroup)this.mSeatView.getParent()).removeView((View)this.mSeatView);
            }
            this.mSeatView.setVisibility(0);
        }
        parent.addView((View)this.mSeatView);
    }

    @Override
    protected void setAvatar(UserInfoKS userInfoBean) {
        super.setAvatar(userInfoBean);
        if (this.mSeatView != null) {
            this.mSeatView.setAvatar(userInfoBean.avatar, userInfoBean.uid, userInfoBean.sex);
        }
    }

    @Override
    protected void setAvatarFrame(String frameUrl) {
        super.setAvatarFrame(frameUrl);
        if (this.mSeatView != null) {
            this.mSeatView.setAvatarFrame(frameUrl);
        }
    }

    @Override
    public void startSpeakingAnimation(int position) {
        this.mSeatView.startSpeakAnim();
    }

    @Override
    public void stopSpeakingAnimation(int position) {
        this.mSeatView.stopSpeakAnim();
    }

    @Override
    public void updateSeats(List<SeatItem> seatItems) {
        super.updateSeats(seatItems);
        if (!FP.empty(seatItems)) {
            this.mSeatView.updateSeat(seatItems.get(0));
        } else {
            this.mSeatView.updateSeat(null);
        }
    }

    @Override
    public void updateSeat(int position, SeatItem data) {
        super.updateSeat(position, data);
        if (position == 0) {
            this.mSeatView.updateSeat(data);
        }
    }

    public Map<Long, Point> getSeatViewLoaction(boolean isAbsolute) {
        HashMap<Long, Point> realLoctionMap = new HashMap<Long, Point>();
        int[] loction = new int[2];
        ScreenWrapperUtils.INSTANCE.getViewPoint(this.mSeatView.getLogoView(), isAbsolute, loction);
        realLoctionMap.put(this.getShowingUid(), new Point(loction[0], loction[1]));
        return realLoctionMap;
    }

    public int getSeatFaceSize() {
        return ResolutionUtils.dip2Px((float)50.0f);
    }

    public int[] getSeatViewPosition() {
        return new int[]{(int)this.mSeatView.getX(), (int)this.mSeatView.getY()};
    }

    @Override
    @Nullable
    public View getItemView(int index) {
        if (index == 0) {
            return this.mSeatView;
        }
        return null;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.isSupportReuse && this.mSeatView != null) {
            this.mSeatView.resetViewState();
        }
        this.mSeatView = null;
    }
}

