/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.screenrecord.impl;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Looper;
import androidx.annotation.RequiresApi;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.plugins.radio.screenrecord.impl.VideoMuxerWrapper;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H$J\b\u0010\u0015\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0014J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020\u0017H\u0016J\b\u0010$\u001a\u00020\u0017H\u0016J\b\u0010%\u001a\u00020\u0017H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder;", "Landroid/media/MediaCodec$Callback;", "()V", "errorCallback", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder$EncodeErrorCallback;", "getErrorCallback", "()Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder$EncodeErrorCallback;", "setErrorCallback", "(Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder$EncodeErrorCallback;)V", "mEncoder", "Landroid/media/MediaCodec;", "mTraceIndex", "", "mVideoMuxer", "Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/VideoMuxerWrapper;", "getMVideoMuxer", "()Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/VideoMuxerWrapper;", "setMVideoMuxer", "(Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/VideoMuxerWrapper;)V", "createMediaFormat", "Landroid/media/MediaFormat;", "getEncoder", "onEncoderConfigured", "", "encoder", "onError", "codec", "e", "Landroid/media/MediaCodec$CodecException;", "onOutputBufferAvailable", "index", "info", "Landroid/media/MediaCodec$BufferInfo;", "onOutputFormatChanged", "format", "release", "start", "stop", "Companion", "EncodeErrorCallback", "radio_debug"})
@RequiresApi(value=21)
public abstract class BaseEncoder
extends MediaCodec.Callback {
    private MediaCodec mEncoder;
    @Nullable
    private VideoMuxerWrapper mVideoMuxer;
    private int mTraceIndex = -1;
    @Nullable
    private EncodeErrorCallback errorCallback;
    @NotNull
    public static final String TAG = "BaseEncoder";
    public static final int INVALID_TRACE_INDEX = -1;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final VideoMuxerWrapper getMVideoMuxer() {
        return this.mVideoMuxer;
    }

    public final void setMVideoMuxer(@Nullable VideoMuxerWrapper videoMuxerWrapper) {
        this.mVideoMuxer = videoMuxerWrapper;
    }

    @Nullable
    public final EncodeErrorCallback getErrorCallback() {
        return this.errorCallback;
    }

    public final void setErrorCallback(@Nullable EncodeErrorCallback encodeErrorCallback) {
        this.errorCallback = encodeErrorCallback;
    }

    public void start() throws IOException {
        String mimeType;
        boolean bl = Looper.myLooper() != null && !Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "should run in a HandlerThread";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        bl = this.mEncoder == null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string3 = "prepared!";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        MediaFormat format = this.createMediaFormat();
        MLog.info((Object)"Encoder", (String)("Create media format: " + format), (Object[])new Object[0]);
        String string4 = mimeType = format.getString("mime");
        if (string4 == null) {
            Intrinsics.throwNpe();
        }
        MediaCodec mediaCodec = MediaCodec.createEncoderByType((String)string4);
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaCodec, (String)"createEncoderByType(mimeType!!)");
        MediaCodec encoder = mediaCodec;
        try {
            encoder.setCallback((MediaCodec.Callback)this);
            encoder.configure(format, null, null, 1);
            this.onEncoderConfigured(encoder);
            encoder.start();
        }
        catch (Throwable e) {
            MLog.error((Object)"Encoder", (String)("Configure codec failure!  with format" + format), (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        this.mEncoder = encoder;
    }

    public void stop() {
        MediaCodec mediaCodec = this.mEncoder;
        if (mediaCodec != null) {
            mediaCodec.stop();
        }
        MediaCodec mediaCodec2 = this.mEncoder;
        if (mediaCodec2 != null) {
            mediaCodec2.release();
        }
        this.mEncoder = null;
    }

    public void release() {
    }

    public void onOutputBufferAvailable(@NotNull MediaCodec codec, int index, @NotNull MediaCodec.BufferInfo info) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            VideoMuxerWrapper videoMuxerWrapper = this.mVideoMuxer;
            if (videoMuxerWrapper == null) break block0;
            videoMuxerWrapper.writeMediaCodecBufferData(this.mTraceIndex, codec, index, info);
        }
    }

    public void onOutputFormatChanged(@NotNull MediaCodec codec, @NotNull MediaFormat format) {
        Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        VideoMuxerWrapper videoMuxerWrapper = this.mVideoMuxer;
        if (videoMuxerWrapper == null) {
            Intrinsics.throwNpe();
        }
        this.mTraceIndex = videoMuxerWrapper.addTrack(format);
    }

    public void onError(@NotNull MediaCodec codec, @NotNull MediaCodec.CodecException e) {
        Intrinsics.checkParameterIsNotNull((Object)codec, (String)"codec");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        EncodeErrorCallback encodeErrorCallback = this.errorCallback;
        if (encodeErrorCallback != null) {
            encodeErrorCallback.onEncodeError(codec, (Throwable)e);
        }
        MLog.error((Object)TAG, (String)("onEncodeError " + codec.getOutputFormat()), (Throwable)((Throwable)e), (Object[])new Object[0]);
    }

    @Nullable
    public final MediaCodec getEncoder() {
        return this.mEncoder;
    }

    protected void onEncoderConfigured(@NotNull MediaCodec encoder) {
        Intrinsics.checkParameterIsNotNull((Object)encoder, (String)"encoder");
    }

    @NotNull
    protected abstract MediaFormat createMediaFormat();

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder$EncodeErrorCallback;", "", "onEncodeError", "", "codec", "Landroid/media/MediaCodec;", "e", "", "radio_debug"})
    public static interface EncodeErrorCallback {
        public void onEncodeError(@NotNull MediaCodec var1, @NotNull Throwable var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/screenrecord/impl/BaseEncoder$Companion;", "", "()V", "INVALID_TRACE_INDEX", "", "TAG", "", "radio_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

