/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.view.View;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import net.ihago.room.srv.follow.EPath;

public class LatentFriendViewHolder
extends RecyclerView.ViewHolder {
    private static String TAG = "LatentFriendViewHolder";
    private RoundImageView avatar;
    private RoundImageView followBt;
    private KvoBinder kvoBinder = new KvoBinder((Object)this);
    private long userUid = 0L;
    private String mGid = "";

    public LatentFriendViewHolder(View itemView) {
        super(itemView);
        this.avatar = (RoundImageView)itemView.findViewById(R.id.iv_user);
        this.followBt = (RoundImageView)itemView.findViewById(R.id.bt_follow);
        itemView.setOnClickListener(v -> {
            if (this.userUid != 0L) {
                RelationInfo info = ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).getRelationLocal(this.userUid);
                ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).requestFollow(info, EPath.PATH_VOICE.getValue());
                this.reportPushClick();
            }
        });
    }

    private void reportPushClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "follow_click").put("follow_enter_type", "45").put("gid", this.mGid));
    }

    public void bindView(long uid, String gid) {
        RelationInfo info;
        if (ServiceManagerProxy.getService(IRelationService.class) != null && (info = ((IRelationService)ServiceManagerProxy.getService(IRelationService.class)).getRelationLocal(uid)) != null) {
            this.kvoBinder.singleBindSourceTo((KvoSource)info);
        }
        this.userUid = uid;
        this.mGid = gid;
        final UserInfoKS userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid);
        if (userInfoKS.ver > 0L) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ImageLoader.loadImage((ImageView)LatentFriendViewHolder.this.avatar, (String)(userInfoKS.avatar + YYImageUtils.getThumbnailPostfix((int)75)));
                }
            });
        } else {
            ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).requestUserInfoFromServer(uid, new OnKSProfileListCallback(){

                public void onUISuccess(List<UserInfoKS> userInfo) {
                    MLog.info((Object)TAG, (String)"onUISuccess", (Object[])new Object[0]);
                    if (userInfo != null && !userInfo.isEmpty()) {
                        ImageLoader.loadImage((ImageView)LatentFriendViewHolder.this.avatar, (String)(userInfo.get((int)0).avatar + YYImageUtils.getThumbnailPostfix((int)75)));
                    }
                }

                public void onError(String reason, long code) {
                    MLog.error((Object)TAG, (String)("onResponseError message:" + reason + " id:" + code), (Object[])new Object[0]);
                }
            });
        }
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    private void onFollowStatusChanged(KvoEventIntent event) {
        RelationInfo info = (RelationInfo)event.source();
        if (info != null) {
            if (info.isFollow()) {
                ImageLoader.loadImage((ImageView)this.followBt, (int)R.drawable.icon_latent_friend_follow);
            } else {
                ImageLoader.loadImage((ImageView)this.followBt, (int)R.drawable.icon_latent_friend_un_follow);
            }
        }
    }
}

