/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.os.Message;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.yy.appbase.callback.SimpleAnimatorListener;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.msg.FollowUserMsg;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import java.util.List;

public class FollowUserHolder
extends AbsMsgItemHolder<FollowUserMsg>
implements View.OnClickListener {
    private static final String TAG = "FollowUserHolder";
    protected View llFollow;
    protected RecycleImageView ivFollowed;
    private CircleImageView ivHead;
    protected YYTextView tvContent;
    protected boolean isFollowed = false;
    protected ObjectAnimator mFollowAnimator = null;
    private RelationInfo relationInfo;
    protected boolean mIsFollowing = false;
    private OnProfileCallback mOnProfileCallback = new OnProfileCallback(){

        public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
            if (!FP.empty(userInfoKSList)) {
                ImageLoader.loadImage((ImageView)FollowUserHolder.this.ivHead, (String)(userInfoKSList.get((int)0).avatar + YYImageUtils.getThumbnailPostfix((int)75, (boolean)true)));
            }
        }

        public void onFail(int id2, String msg, String response) {
        }
    };
    private Runnable timeOut = () -> {
        if (this.mFollowAnimator != null && this.mFollowAnimator.isRunning()) {
            this.mFollowAnimator.cancel();
        }
    };

    public FollowUserHolder(@NonNull View itemView) {
        super(itemView, false);
        this.llFollow = itemView.findViewById(R.id.ll_follow);
        this.ivFollowed = (RecycleImageView)itemView.findViewById(R.id.iv_follow);
        this.ivHead = (CircleImageView)itemView.findViewById(R.id.iv_c_head);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_followed);
        this.llFollow.setOnClickListener((View.OnClickListener)this);
        this.ivHead.setOnClickListener((View.OnClickListener)this);
        itemView.setBackgroundResource(R.drawable.bg_b3ffb717_4dp);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ll_follow) {
            MLog.info((Object)TAG, (String)"follow user clicked", (Object[])new Object[0]);
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.CLICK_FOLLOWER_USER;
                msg.obj = this.getItemMsg();
                this.mActionHandler.onAction(msg);
                this.startAnim();
            }
        } else if (v.getId() == R.id.iv_c_head && this.mActionHandler != null) {
            Message msg = Message.obtain();
            msg.what = ActionDefine.SHOW_USER_PROFILE;
            msg.obj = ((FollowUserMsg)((Object)this.getItemMsg())).getFollowUid();
            this.mActionHandler.onAction(msg);
        }
    }

    @Override
    public void bindView(FollowUserMsg newData, int position) {
        super.bindView(newData, position);
        this.itemView.setAlpha(1.0f);
        Long followUid = newData.getFollowUid();
        if (followUid != null && followUid > 0L) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(newData.getFollowUid().longValue(), this.mOnProfileCallback);
        }
        this.mBinder.clearKvoConnection("relation");
        this.relationInfo = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationLocal(followUid.longValue());
        this.mBinder.singleBindSourceTo("relation", (KvoSource)this.relationInfo);
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    public void updateFollowStatus(KvoEventIntent event) {
        RelationInfo mRelation = (RelationInfo)event.source();
        this.updateFollowState(mRelation);
    }

    protected void updateFollowState(RelationInfo mRelation) {
        this.mIsFollowing = false;
        if (this.mFollowAnimator != null) {
            this.mFollowAnimator.end();
        }
        if (this.getItemMsg() == null || mRelation == null) {
            return;
        }
        this.llFollow.setEnabled(!mRelation.isFollow());
        if (mRelation.isFollow()) {
            YYTaskExecutor.removeTask((Runnable)this.timeOut);
            this.tvContent.setText(R.string.btn_follow_user_followed);
            this.isFollowed = true;
            this.ivFollowed.setImageResource(R.drawable.icon_top_video_follow);
            this.ivFollowed.setBackgroundResource(R.drawable.bg_white_24_corner);
            this.ivFollowed.setRotation(0.0f);
            this.ivFollowed.setVisibility(8);
        } else {
            this.tvContent.setText(R.string.channel_radio_video_un_follow_tips);
            this.isFollowed = false;
            this.ivFollowed.setImageResource(R.drawable.icon_top_video_follow);
            this.ivFollowed.setBackgroundResource(R.drawable.bg_white_24_corner);
            this.ivFollowed.setRotation(0.0f);
            this.ivFollowed.setVisibility(0);
        }
    }

    protected void startAnim() {
        this.mIsFollowing = true;
        YYTaskExecutor.removeTask((Runnable)this.timeOut);
        YYTaskExecutor.postToMainThread((Runnable)this.timeOut, (long)5000L);
        this.tvContent.setText(R.string.channel_radio_video_un_follow_tips);
        this.ivFollowed.setImageResource(R.drawable.icon_radio_following);
        this.ivFollowed.setBackgroundResource(R.color.transparent);
        this.ivFollowed.setVisibility(0);
        this.mFollowAnimator = ObjectAnimator.ofFloat((Object)this.ivFollowed, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        this.mFollowAnimator.setDuration(1000L);
        this.mFollowAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mFollowAnimator.setRepeatCount(-1);
        this.mFollowAnimator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            public void onAnimationCancel(Animator animation) {
                FollowUserHolder.this.onAnimationCancel();
            }
        });
        this.mFollowAnimator.start();
    }

    protected void onAnimationCancel() {
        this.updateFollowState(this.relationInfo);
    }
}

