/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.graphics.Color;
import android.os.Message;
import android.text.method.LinkMovementMethod;
import android.view.View;
import androidx.annotation.NonNull;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.BasicGroupEnterConfig;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.msg.EnterRoomMsg;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class BasicGroupEnterRoomMsgHolder
extends AbsMsgItemHolder<EnterRoomMsg> {
    private static final String TAG = "BasicGroupEnterRoomMsgHolder";
    private YYTextView tvText;
    private List<String> mCopywritingLibrary;

    public BasicGroupEnterRoomMsgHolder(@NonNull View itemView) {
        super(itemView, false);
        this.tvText = (YYTextView)itemView.findViewById(R.id.tv_c_text);
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.BASIC_GROUP_ENTER_CONFIG);
        if (config instanceof BasicGroupEnterConfig) {
            this.mCopywritingLibrary = ((BasicGroupEnterConfig)config).getCopywritingLibrary();
        }
    }

    @Override
    public void bindView(EnterRoomMsg newData, int position) {
        super.bindView(newData, position);
        String enterText = ResourceUtils.getString((int)R.string.basic_group_enter_room_default_tips);
        this.tvText.setMovementMethod(LinkMovementMethod.getInstance());
        if (this.mCopywritingLibrary != null && this.mCopywritingLibrary.size() > 0) {
            int i = new Random().nextInt(this.mCopywritingLibrary.size());
            enterText = this.mCopywritingLibrary.get(i);
            MLog.info((Object)TAG, (String)("bindView arrays = " + Arrays.toString(this.mCopywritingLibrary.toArray())), (Object[])new Object[0]);
            ChainSpan.of().beginBlock().append((CharSequence)newData.getNick(), new Object[]{TextSpan.of().color(Color.parseColor((String)"#EA7F07")).build()}).onBlockClick(this::itemClick).endBlock().space().append((CharSequence)enterText).onFinish(spannable -> {
                this.tvText.setText((CharSequence)spannable);
                return null;
            }).build();
        } else {
            ChainSpan.of().beginBlock().append((CharSequence)String.format(enterText, newData.getNick())).onBlockClick(this::itemClick).endBlock().onFinish(spannable -> {
                this.tvText.setText((CharSequence)spannable);
                return null;
            }).build();
        }
    }

    private void itemClick() {
        if (this.mActionHandler != null) {
            Message msg = Message.obtain();
            msg.what = ActionDefine.SHOW_USER_PROFILE;
            msg.obj = ((EnterRoomMsg)((Object)this.getItemMsg())).getUid();
            this.mActionHandler.onAction(msg);
        }
    }
}

