/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.transform;

import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import biz.IMMsgItem;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.component.publicscreen.PublicScreenThemeUtil;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.transform.BaseMsgTransform;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

public class RoomPluginMsgTransform
extends BaseMsgTransform {
    private static final String TAG = "RoomPluginMsgTransform";

    @Override
    public BaseImMsg transform(String msgId, IMMsgItem msgItem) {
        PureTextMsg msg = new PureTextMsg(super.transform(msgId, msgItem));
        this.transformInner(msg);
        return msg;
    }

    public BaseImMsg transform(String msgId, BaseImMsg msgItem) {
        PureTextMsg msg = new PureTextMsg(msgItem);
        this.transformInner(msg);
        return msg;
    }

    private final void transformInner(PureTextMsg msg) {
        MsgSection section;
        MsgSection msgSection = section = !FP.empty((Collection)msg.getSections()) ? (MsgSection)msg.getSections().get(0) : null;
        if (section != null) {
            int type = section.getType();
            String content = section.getContent();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"type:%d, content:%s", (Object[])new Object[]{type, content});
            }
            if (StringUtils.isNotEmpty((String)content)) {
                try {
                    ForegroundColorSpan colorSpan;
                    int contentType;
                    String pid;
                    JSONObject jsonObject = JsonParser.obtainJSONObject((String)content);
                    boolean open = false;
                    String plugin = "";
                    if (type == 2006) {
                        open = jsonObject.optBoolean("open");
                        plugin = ResourceUtils.getString((int)R.string.title_voice_call);
                    } else if (type == 2007) {
                        open = true;
                        pid = jsonObject.optString("pid");
                        contentType = jsonObject.optInt("type", -1);
                        plugin = this.getPluginName(pid, contentType);
                    } else if (type == 2008) {
                        open = false;
                        pid = jsonObject.optString("pid");
                        contentType = jsonObject.optInt("type", -1);
                        plugin = this.getPluginName(pid, contentType);
                    }
                    String string2 = ResourceUtils.getString((int)(open ? R.string.tips_turn_on : R.string.tips_turn_off), (Object[])new Object[]{plugin});
                    if (open && type != 2006) {
                        SpannableString session = new SpannableString((CharSequence)("[" + plugin + "]"));
                        colorSpan = new ForegroundColorSpan(ColorUtils.parseColor((String)"#EA7F07"));
                        session.setSpan((Object)colorSpan, 0, session.length(), 17);
                        msg.setSessionTips((CharSequence)session);
                    } else {
                        msg.setSessionTips((CharSequence)string2);
                    }
                    SpannableString spannableString = new SpannableString((CharSequence)string2);
                    colorSpan = new ForegroundColorSpan(PublicScreenThemeUtil.INSTANCE.getAtTextLightColor());
                    spannableString.setSpan((Object)colorSpan, 0, spannableString.length(), 17);
                    msg.setMsgText((CharSequence)spannableString);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    MLog.error((Object)TAG, (String)"ESTOpenVoiceChat session parse error:%s", (Object[])new Object[]{content});
                }
            } else {
                MLog.error((Object)TAG, (String)"session empty!!!", (Object[])new Object[0]);
            }
        }
    }

    private String getPluginName(String pid, int contentType) {
        String plugin = pid;
        GameInfo gameInfoByGid = null;
        if (ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class) != null) {
            gameInfoByGid = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(pid);
        }
        if (gameInfoByGid != null) {
            plugin = gameInfoByGid.getGname();
        } else if (pid.startsWith("P_") || contentType == 10) {
            plugin = ResourceUtils.getString((int)R.string.title_voice_mode);
        }
        return plugin;
    }
}

