/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.widget.FlowLayout;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.publicscreen.msg.SwitchLBSMsg;
import com.yy.hiyo.channel.component.publicscreen.holder.MsgLeadingMarginSpan;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgTitleBarHolder;
import com.yy.hiyo.component.publicscreen.theme.IThemeView;
import com.yy.hiyo.component.publicscreen.theme.ThemePackage;
import com.yy.hiyo.component.publicscreen.widge.BaseUserTitleView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchLBSHolder
extends AbsMsgTitleBarHolder<SwitchLBSMsg> {
    private static final String TAG = "SwitchLBSHolder";
    private static final int DP_5_IN_DIMEN = ResourceUtils.getDimen((int)R.dimen.dp_5);
    private YYTextView requestTv = (YYTextView)this.itemView.findViewById(R.id.tv_c_join);
    private YYTextView contentTv = (YYTextView)this.itemView.findViewById(R.id.tv_c_text);
    private SwitchLBSMsg mMsg;
    private BaseUserTitleView titleView;
    private View contentView = this.itemView.findViewById(R.id.layout_content);
    private int recyclerViewWidth = 0;

    public SwitchLBSHolder(@NotNull View v) {
        super(v, false);
        this.titleView = (BaseUserTitleView)this.itemView.findViewById(R.id.butv_c);
        this.titleView.getFlowLayout().setMaxRows(1);
        this.requestTv.setOnClickListener(v12 -> {
            if (this.mActionHandler != null) {
                Message msg = Message.obtain();
                msg.what = ActionDefine.CLICK_SWITCH_LBS;
                msg.obj = this.getItemMsg();
                this.mActionHandler.onAction(msg);
            }
        });
        ((IThemeView)this.contentTv).setThemeInterceptor(new IThemeView.Interceptor(){

            @Override
            public boolean intercept(@Nullable ThemePackage themePackage) {
                if (SwitchLBSHolder.this.mChannelMode == 1) {
                    Drawable drawable2;
                    int contentColor = themePackage.getContentColorResId();
                    if (contentColor != 0) {
                        SwitchLBSHolder.this.contentTv.setTextColor(ResourceUtils.getColor((int)contentColor));
                    }
                    if (SwitchLBSHolder.this.contentView != null && (drawable2 = themePackage.getBackgroundDrawable()) != null) {
                        SwitchLBSHolder.this.contentView.setBackground(drawable2);
                    }
                    return true;
                }
                return false;
            }
        });
        this.titleView.setOnMeasuredListener((width, height) -> this.updateText());
    }

    @Override
    public void bindView(@NotNull SwitchLBSMsg newData, int position) {
        super.bindView(newData, position);
        this.mBinder.singleBindSourceTo("msg", (KvoSource)newData);
        this.mMsg = newData;
        this.updateText();
    }

    @KvoMethodAnnotation(name="clickState", sourceClass=SwitchLBSMsg.class, thread=1)
    public void onBtnState(KvoEventIntent event) {
        this.mMsg = (SwitchLBSMsg)this.getItemMsg();
        if (this.mMsg != null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"clickState : %d", (Object[])new Object[]{this.mMsg.getClickState()});
            }
            if (this.mMsg.getClickState() == 1) {
                if (this.mChannelMode == 1) {
                    this.requestTv.setAlpha(0.3f);
                } else {
                    this.requestTv.setAlpha(0.5f);
                }
                this.requestTv.setEnabled(false);
            } else {
                this.requestTv.setAlpha(1.0f);
                this.requestTv.setEnabled(true);
            }
        }
    }

    private void updateText() {
        if (this.mMsg == null) {
            return;
        }
        String nick = this.mMsg.getMyNick();
        if (FP.empty((CharSequence)nick)) {
            return;
        }
        ChainSpan.of().append((CharSequence)("@" + nick), new Object[]{TextSpan.of().size(13).color(ColorUtils.parseColor((String)"#FED77A")).build()}).space().append((CharSequence)ResourceUtils.getString((int)R.string.tips_enter_room_enable_lbs)).onFinish(data -> {
            boolean isBaseMode;
            boolean bl = isBaseMode = this.mThemeRes != null && this.mThemeRes.getCurrentMode() == 1;
            if (isBaseMode) {
                this.contentTv.setText((CharSequence)data);
            } else {
                int offset = this.calculateTextIndentOffset((ViewGroup.MarginLayoutParams)this.contentView.getLayoutParams());
                this.setTextIndent((CharSequence)data, offset);
            }
        }).build();
    }

    private int calculateTextIndentOffset(ViewGroup.MarginLayoutParams params) {
        FlowLayout flowLayout = this.titleView.getFlowLayout();
        flowLayout.setMaxRows(1);
        int topOffset = 0;
        if (flowLayout.getRowsCount() > 0) {
            int maxHeight = flowLayout.getHeightForRow(0);
            Paint.FontMetrics metrics = this.contentTv.getPaint().getFontMetrics();
            int textHeight = (int)(metrics.descent - metrics.ascent);
            topOffset = textHeight + (maxHeight - textHeight) / 2;
            MLog.debug((Object)TAG, (String)"rowSize %d, maxHeight %d, textHeight %d, topOffset %d", (Object[])new Object[]{flowLayout.getRowsCount(), maxHeight, textHeight, topOffset});
        }
        int titleViewWidth = this.titleView.getWidth();
        this.makeSureRecyclerViewWidth();
        MLog.debug((Object)TAG, (String)("recyclerViewWidth = " + this.recyclerViewWidth + ", titleViewWidth = " + titleViewWidth), (Object[])new Object[0]);
        params.leftMargin = DP_5_IN_DIMEN;
        if (this.recyclerViewWidth > 0 && (double)((float)titleViewWidth / (float)this.recyclerViewWidth) <= 0.9) {
            params.topMargin = -topOffset - 9;
            this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
            return titleViewWidth;
        }
        params.topMargin = DP_5_IN_DIMEN;
        this.contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        return 0;
    }

    private void makeSureRecyclerViewWidth() {
        if (this.recyclerViewWidth != 0) {
            return;
        }
        ViewParent parent = this.itemView.getParent();
        if (parent == null) {
            return;
        }
        this.recyclerViewWidth = ((View)parent).getWidth();
    }

    private void setTextIndent(CharSequence text, int indentDistance) {
        MLog.debug((Object)TAG, (String)("setTextIndent: " + text + ", indentDistance: " + indentDistance), (Object[])new Object[0]);
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        MsgLeadingMarginSpan standard = new MsgLeadingMarginSpan(1, indentDistance);
        builder.setSpan((Object)standard, 0, builder.length(), 17);
        this.contentTv.setText((CharSequence)builder);
    }
}

