/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Message;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.base.bean.ActionDefine;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenData;
import com.yy.hiyo.channel.cbase.publicscreen.callback.OnMsgClickListener;
import com.yy.hiyo.channel.cbase.publicscreen.msg.CommonBtnMsgItem;
import com.yy.hiyo.channel.cbase.publicscreen.msg.GrabCusPacketMsg;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.holder.AbsMsgItemHolder;
import com.yy.hiyo.component.publicscreen.theme.ThemePackage;
import com.yy.hiyo.component.publicscreen.theme.themeview.YYThemeConstraintLayout;
import java.util.Map;

public class GrabCusPacketMsgHolder
extends AbsMsgItemHolder<GrabCusPacketMsg> {
    private static final String TAG = "GrabCusPacketMsgHolder";
    private final ViewGroup.LayoutParams rootParams;
    private CircleImageView ivHead;
    private YYTextView tvContent;
    private YYTextView tvJoin;
    private RecycleImageView ivPacket;
    private YYThemeConstraintLayout ivBg;
    private RecycleImageView jumpBtn;
    private int simpleContentMarginStart = -1;
    private int recyclerViewWidth = 0;

    public GrabCusPacketMsgHolder(@NonNull View itemView) {
        super(itemView, false);
        this.ivHead = (CircleImageView)itemView.findViewById(R.id.iv_c_head);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_c_text);
        this.tvJoin = (YYTextView)itemView.findViewById(R.id.tv_c_join);
        this.ivPacket = (RecycleImageView)itemView.findViewById(R.id.iv_packet);
        this.jumpBtn = (RecycleImageView)itemView.findViewById(R.id.icon_arrow);
        this.ivPacket.setImageDrawable(null);
        this.ivBg = (YYThemeConstraintLayout)itemView.findViewById(R.id.channel_msg_content);
        this.rootParams = this.ivBg.getLayoutParams();
        this.ivBg.setThemeInterceptor(themePackage -> true);
        itemView.setOnClickListener(v -> {
            Map ext;
            OnMsgClickListener listener2;
            OnMsgClickListener onMsgClickListener = listener2 = ((GrabCusPacketMsg)this.getItemMsg()).getCommonBtnMsgItem() != null && ((GrabCusPacketMsg)this.getItemMsg()).getCommonBtnMsgItem().getListener() != null ? (OnMsgClickListener)((GrabCusPacketMsg)this.getItemMsg()).getCommonBtnMsgItem().getListener().get() : null;
            if (listener2 != null) {
                listener2.onClick((IPublicScreenData)((GrabCusPacketMsg)this.getItemMsg()).getCommonBtnMsgItem(), null);
            }
            if (((GrabCusPacketMsg)this.getItemMsg()).getCommonBtnMsgItem() != null && (ext = ((GrabCusPacketMsg)this.getItemMsg()).getCommonBtnMsgItem().getExt()) != null) {
                Object activityId = ext.get("activity_id");
                Object actUrl = ext.get("activity_url");
                if (activityId instanceof String) {
                    ChannelTrack.INSTANCE.screenActRemindClick((String)activityId, actUrl instanceof String ? (String)actUrl : "");
                }
            }
        });
    }

    @Override
    public void bindView(GrabCusPacketMsg newData, int position) {
        super.bindView(newData, position);
        CommonBtnMsgItem packetMsg = newData.getCommonBtnMsgItem();
        if (packetMsg != null) {
            int rootWidth = -2;
            ImageLoader.loadImage((RecycleImageView)this.ivHead, (String)(TextUtils.isEmpty((CharSequence)packetMsg.getSenderAvatar()) ? "" : packetMsg.getSenderAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.profile_default_header);
            if (!TextUtils.isEmpty((CharSequence)packetMsg.getIconUrl())) {
                this.ivPacket.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.ivPacket, (String)packetMsg.getIconUrl());
                rootWidth = -2;
            } else {
                this.ivPacket.setVisibility(8);
            }
            this.updateContent(packetMsg.getContent());
            rootWidth = this.setBtn(packetMsg, rootWidth);
            this.rootParams.width = rootWidth = this.setBg(newData, packetMsg, rootWidth);
            this.ivBg.setLayoutParams(this.rootParams);
            this.report(newData);
            if (((GrabCusPacketMsg)this.getItemMsg()).getFrom() > 0L && this.jumpBtn.getVisibility() == 0) {
                this.ivHead.setClickable(true);
                this.ivHead.setOnClickListener(v -> {
                    if (this.mActionHandler != null) {
                        Message msg = Message.obtain();
                        msg.what = ActionDefine.SHOW_USER_PROFILE;
                        msg.obj = ((GrabCusPacketMsg)this.getItemMsg()).getFrom();
                        this.mActionHandler.onAction(msg);
                    }
                });
            } else {
                this.ivHead.setOnClickListener(null);
                this.ivHead.setClickable(false);
            }
            this.ivHead.requestLayout();
        }
        if (this.recyclerViewWidth == 0) {
            this.itemView.post(() -> {
                ViewParent parent = this.itemView.getParent();
                if (parent != null) {
                    this.recyclerViewWidth = ((View)parent).getWidth();
                    this.tvContent.setMaxWidth(this.recyclerViewWidth - ResourceUtils.getDimen((int)R.dimen.dp_5));
                }
            });
        } else {
            this.tvContent.setMaxWidth(this.recyclerViewWidth - ResourceUtils.getDimen((int)R.dimen.dp_5));
        }
    }

    private int setBtn(CommonBtnMsgItem packetMsg, int rootWidth) {
        if (!TextUtils.isEmpty((CharSequence)packetMsg.getBtnIcon())) {
            this.tvJoin.setVisibility(8);
            ImageLoader.loadImage((RecycleImageView)this.jumpBtn, (String)(packetMsg.getBtnIcon() + YYImageUtils.getThumbnailPostfix((int)75)));
            this.jumpBtn.setVisibility(0);
        } else {
            this.jumpBtn.setVisibility(8);
            if (TextUtils.isEmpty((CharSequence)packetMsg.getBtnText())) {
                this.tvJoin.setVisibility(8);
                this.tvJoin.setText((CharSequence)"");
            } else {
                this.tvJoin.setVisibility(0);
                this.tvJoin.setText((CharSequence)packetMsg.getBtnText());
            }
            rootWidth = -2;
        }
        return rootWidth;
    }

    private int setBg(GrabCusPacketMsg newData, CommonBtnMsgItem packetMsg, int rootWidth) {
        Object draRes;
        int res = 0;
        if (packetMsg.getExt() != null && (draRes = packetMsg.getExt().get("bg_drawable_res")) instanceof Integer) {
            res = (Integer)draRes;
        }
        if (!TextUtils.isEmpty((CharSequence)packetMsg.getBgColor())) {
            this.ivBg.setBackground((Drawable)DrawableUtil.getRoundDrawable((int)5, (int)ColorUtils.parseColor((String)packetMsg.getBgColor())));
        } else if (res > 0) {
            this.ivBg.setBackground(DrawableUtil.getDrawable((int)res));
        } else if (!TextUtils.isEmpty((CharSequence)packetMsg.getBgUrl())) {
            this.loadBgImg(newData, packetMsg);
        } else {
            ThemePackage themePackage = this.mThemeRes.getThemePackage("msg_background");
            if (themePackage != null) {
                rootWidth = -2;
                this.ivBg.setBackground(themePackage.getBackgroundDrawable());
            }
        }
        return rootWidth;
    }

    private void report(GrabCusPacketMsg newData) {
        Map ext;
        if (newData.getCommonBtnMsgItem() != null && (ext = newData.getCommonBtnMsgItem().getExt()) != null) {
            Object activityId = ext.get("activity_id");
            Object actUrl = ext.get("activity_url");
            if (activityId instanceof String) {
                ChannelTrack.INSTANCE.screenActRemindShow((String)activityId, actUrl instanceof String ? (String)actUrl : "");
            }
        }
    }

    private void loadBgImg(final GrabCusPacketMsg newData, CommonBtnMsgItem packetMsg) {
        ImageLoader.loadBitmap((Context)this.itemView.getContext(), (String)packetMsg.getBgUrl(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
                MLog.error((Object)GrabCusPacketMsgHolder.TAG, (String)"loadBitmap fail", (Object[])new Object[0]);
            }

            public void onResourceReady(Bitmap bitmap) {
                if (GrabCusPacketMsgHolder.this.getItemMsg() != newData) {
                    return;
                }
                BitmapDrawable bitmapDrawable = new BitmapDrawable(GrabCusPacketMsgHolder.this.itemView.getResources(), bitmap);
                GrabCusPacketMsgHolder.this.ivBg.setBackground((Drawable)bitmapDrawable);
            }
        });
    }

    private void updateContent(String text) {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.tvContent.getLayoutParams();
        layoutParams.leftMargin = this.getSimpleContentMarginStart(this.tvContent.getContext());
        this.tvContent.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.ivHead.post(() -> {
            int indentDistance = this.ivHead.getWidth() + this.getSimpleContentMarginStart(this.tvContent.getContext());
            this.setTextIndent(text, indentDistance);
        });
    }

    private void setTextIndent(String text, int indentDistance) {
        MLog.debug((Object)TAG, (String)("setTextIndent: " + text + ", indentDistance: " + indentDistance), (Object[])new Object[0]);
        SpannableString spannableString = new SpannableString((CharSequence)text);
        LeadingMarginSpan.Standard what = new LeadingMarginSpan.Standard(indentDistance, 0);
        spannableString.setSpan((Object)what, 0, spannableString.length(), 18);
        this.tvContent.setText((CharSequence)spannableString);
    }

    private int getSimpleContentMarginStart(Context context) {
        if (this.simpleContentMarginStart != -1) {
            return this.simpleContentMarginStart;
        }
        this.simpleContentMarginStart = context.getResources().getDimensionPixelSize(R.dimen.dp_5);
        return this.simpleContentMarginStart;
    }
}

