/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.chat.viewholder;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import com.yy.appbase.common.Callback;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.TextSpan;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.chat.bean.GreetingCardMsgItem;
import com.yy.hiyo.component.publicscreen.chat.viewholder.TextHolder;

public class GreetingCardBuilder
implements TextHolder.TextBuilder<GreetingCardMsgItem> {
    private static final String TAG = "GreetingCardBuilder";
    private static final String IMAGE_THUMBNAIL = YYImageUtils.getThumbnailPostfix((int)75);
    private static final int GIFT_ICON_SIZE = ResolutionUtils.dip2Px((float)25.0f);
    @ColorInt
    private static final int COLOR_NAME = Color.parseColor((String)"#80ffffff");
    @ColorInt
    private static final int COLOR_WISH = Color.parseColor((String)"#ffffff");
    @ColorInt
    private static final int COLOR_GREETING = Color.parseColor((String)"#fed77a");

    @Override
    public void buildText(TextHolder<GreetingCardMsgItem> holder, GreetingCardMsgItem data, Callback<CharSequence> callback) {
        this.buildLtrText(holder, data, callback);
    }

    private void buildLtrText(TextHolder<GreetingCardMsgItem> holder, GreetingCardMsgItem data, Callback<CharSequence> callback) {
        ChainSpan.of().beginBlock().append((CharSequence)data.getSenderName(), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).space().onBlockClick(() -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"click sender", (Object[])new Object[0]);
            }
            holder.onClickUser(data.getUid());
        }).endBlock().append(R.string.tips_greeting_card_public_screen_wish, (Object)TextSpan.of().size(13).color(COLOR_WISH).build()).beginBlock().space().append((CharSequence)data.getReceiverName(), new Object[]{TextSpan.of().size(13).color(COLOR_NAME).build()}).onBlockClick(() -> holder.onClickUser(data.getReceiverUid())).endBlock().space().image(data.getGiftUrl() + IMAGE_THUMBNAIL, GIFT_ICON_SIZE, GIFT_ICON_SIZE, R.drawable.public_screen_gift).append((CharSequence)ResourceUtils.getString((int)R.string.short_tips_gift_combo, (Object[])new Object[]{String.valueOf(data.getGiftCount())}), new Object[]{TextSpan.of().size(13).color(-1).build()}).newLine().append((CharSequence)data.getGiftSlogan(), new Object[]{TextSpan.of().size(13).color(COLOR_GREETING).build()}).onUpdate(arg_0 -> callback.onResponse(arg_0)).build();
    }
}

