/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.component.publicscreen.chat.viewholder;

import android.graphics.Color;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.CustomLinkMovementMethod;
import com.yy.hiyo.component.publicscreen.R;
import com.yy.hiyo.component.publicscreen.chat.bean.CustomPublicScreenItem;
import com.yy.hiyo.component.publicscreen.chat.viewholder.BaseViewHolder;

public class CustomViewHolder
extends BaseViewHolder<CustomPublicScreenItem> {
    private TextView mTvContent;
    private CircleImageView mIvHeader;
    private LinearLayout mLlContent;

    public CustomViewHolder(View itemView) {
        super(itemView);
        this.mTvContent = (TextView)itemView.findViewById(R.id.tv_public_screen_content);
        this.mIvHeader = (CircleImageView)itemView.findViewById(R.id.iv_public_screen_header);
        this.mLlContent = (LinearLayout)itemView.findViewById(R.id.ll_public_screen);
        this.mIvHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomViewHolder.this.mOnProfileCardShowCallback != null) {
                    CustomViewHolder.this.mOnProfileCardShowCallback.onProfileCardShow(((CustomPublicScreenItem)((Object)CustomViewHolder.this.getData())).getUid());
                }
            }
        });
    }

    public void setData(CustomPublicScreenItem data) {
        super.setData((Object)data);
        if (data != null) {
            int color2 = ResourceUtils.getColor((int)R.color.voice_chat_content_color);
            if (!TextUtils.isEmpty((CharSequence)data.getBgColor())) {
                color2 = Color.parseColor((String)data.getBgColor());
            }
            this.mTvContent.setTextColor(color2);
            this.mTvContent.setMovementMethod((MovementMethod)CustomLinkMovementMethod.getInstance());
            this.mTvContent.setText(data.getCharContent());
            this.mTvContent.setTag((Object)this.getLayoutPosition());
            this.mLlContent.setBackgroundResource(R.drawable.shape_public_screen_item);
            if (!TextUtils.isEmpty((CharSequence)data.getHeader())) {
                this.mIvHeader.setVisibility(0);
                ImageLoader.loadImage((RecycleImageView)this.mIvHeader, (String)(data.getHeader() + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.profile_default_header);
            }
        }
    }
}

