/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.business.manager;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.business.manager.BaseManager;
import com.yy.hiyo.channel.plugins.pickme.business.manager.IRoleManager;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoService;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RoleManager
extends BaseManager
implements IRoleManager,
ISeatUpdateListener {
    private static final String TAG = "FTPickMe#RoleManager";
    private final MutableLiveData<Integer> mRoleType = new MutableLiveData();

    public RoleManager(@NotNull PickMeContext context, @NotNull IProtoService protoService) {
        super(context, protoService);
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        this.checkRoleTypeBySeatData();
    }

    private void checkRoleTypeBySeatData() {
        long selfUid = AccountUtil.getUid();
        ISeatService seatService = this.mContext.getRoomPageContext().getChannel().getSeatService();
        if (seatService.isInFirstSeat(selfUid)) {
            this.onRoleChanged(2);
        } else if (seatService.isInSeat(selfUid)) {
            this.onRoleChanged(1);
        } else {
            this.onRoleChanged(0);
        }
    }

    private void onRoleChanged(int roleType) {
        if (this.mRoleType.getValue() != null && (Integer)this.mRoleType.getValue() == roleType) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onRoleChanged, from %d to %d", (Object[])new Object[]{this.mRoleType.getValue(), roleType});
        }
        this.mRoleType.setValue((Object)roleType);
    }

    @Override
    public LiveData<Integer> getRoleType() {
        return this.mRoleType;
    }

    @Override
    public void onServiceInit() {
        super.onServiceInit();
        this.checkRoleTypeBySeatData();
        this.mContext.getRoomPageContext().getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
    }

    @Override
    public void onServiceDestroy() {
        super.onServiceDestroy();
        this.mContext.getRoomPageContext().getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
    }
}

