/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.plugins.pickme.R;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IFunctionMenuClickListener;

public class FunctionMenuView
extends YYRelativeLayout
implements View.OnClickListener {
    public TextView mTvFuncBtn;
    public TextView mTvEndBtn;
    public ImageView mIvIcon;
    private boolean isAniming = false;
    private int animTime = 300;
    private int stayCloseTime = 3000;
    private boolean isOpen = false;
    private IFunctionMenuClickListener listener;
    private Runnable mCloseRunnable = () -> {
        if (this.isOpen) {
            this.closeFunctionMenuView();
        }
    };

    public void setListener(IFunctionMenuClickListener listener) {
        this.listener = listener;
    }

    public FunctionMenuView(Context context) {
        super(context);
        this.createView();
    }

    public FunctionMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView();
    }

    public FunctionMenuView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView();
    }

    private void createView() {
        FunctionMenuView.inflate((Context)this.getContext(), (int)R.layout.view_pick_me_function_menu_channel, (ViewGroup)this);
        this.mTvFuncBtn = (TextView)this.findViewById(R.id.tv_func_btn);
        this.mTvEndBtn = (TextView)this.findViewById(R.id.tv_end_btn);
        this.mIvIcon = (ImageView)this.findViewById(R.id.iv_pick_me);
        this.mIvIcon.setOnClickListener((View.OnClickListener)this);
        this.mTvFuncBtn.setOnClickListener((View.OnClickListener)this);
        this.mTvEndBtn.setOnClickListener((View.OnClickListener)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.openFunctionMenuView();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        YYTaskExecutor.removeTask((Runnable)this.mCloseRunnable);
        this.clearAnimation();
    }

    private void openFunctionMenuView() {
        YYTaskExecutor.removeTask((Runnable)this.mCloseRunnable);
        this.isAniming = true;
        this.isOpen = true;
        int width = ResolutionUtils.dip2Px((float)200.0f);
        int transX = LanguageUtils.isRtl() ? ResolutionUtils.dip2Px((float)42.0f) - width : width - ResolutionUtils.dip2Px((float)42.0f);
        ObjectAnimator tranAni = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{transX, 0.0f});
        tranAni.setDuration((long)this.animTime);
        tranAni.start();
        tranAni.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FunctionMenuView.this.isAniming = false;
                YYTaskExecutor.postToMainThread((Runnable)FunctionMenuView.this.mCloseRunnable, (long)FunctionMenuView.this.stayCloseTime);
            }
        });
    }

    private void closeFunctionMenuView() {
        YYTaskExecutor.removeTask((Runnable)this.mCloseRunnable);
        this.isAniming = true;
        this.isOpen = false;
        int width = ResolutionUtils.dip2Px((float)200.0f);
        int transX = LanguageUtils.isRtl() ? ResolutionUtils.dip2Px((float)42.0f) - width : width - ResolutionUtils.dip2Px((float)42.0f);
        ObjectAnimator tranAni = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{0.0f, transX});
        tranAni.setDuration((long)this.animTime);
        tranAni.start();
        tranAni.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FunctionMenuView.this.isAniming = false;
            }
        });
    }

    public void onClick(View v) {
        YYTaskExecutor.removeTask((Runnable)this.mCloseRunnable);
        YYTaskExecutor.postToMainThread((Runnable)this.mCloseRunnable, (long)this.stayCloseTime);
        if (this.listener == null) {
            return;
        }
        if (v == this.mTvFuncBtn) {
            this.listener.onFunctionClick();
        } else if (v == this.mTvEndBtn) {
            this.listener.onEndClick();
        } else if (v == this.mIvIcon) {
            if (this.isAniming) {
                return;
            }
            if (this.isOpen) {
                this.closeFunctionMenuView();
            } else {
                this.openFunctionMenuView();
            }
            if (this.listener != null) {
                this.listener.onIconClick();
            }
        }
    }
}

