/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui;

import androidx.annotation.NonNull;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.plugins.pickme.DR;
import com.yy.hiyo.channel.plugins.pickme.bean.MatchSuccessInfo;
import com.yy.hiyo.channel.plugins.pickme.common.MatchEffectLevel;
import com.yy.hiyo.channel.plugins.pickme.ui.callback.IAddMatchEffectListener;
import com.yy.hiyo.dyres.inner.DResource;
import java.util.LinkedList;

public class MatchEffectViewManager {
    private static final String TAG = "FTPickMe#MatchEffectViewManager";
    private LinkedList<MatchSuccessInfo> matchSuccessInfoLinkedList;
    private boolean isFinish = false;
    private DResource[] oldSvgaPath = new DResource[]{DR.sv_pick_me_match_1_old, DR.sv_pick_me_match_2_old, DR.sv_pick_me_match_3_old};
    private DResource[] svgaPath = new DResource[]{DR.sv_pick_me_match_1, DR.sv_pick_me_match_2, DR.sv_pick_me_match_3};

    public MatchEffectViewManager() {
        FeatureLog.i((String)TAG, (String)"create MatchEffectViewManager", (Object[])new Object[0]);
        this.matchSuccessInfoLinkedList = new LinkedList();
    }

    public void addMatchSuccess(MatchSuccessInfo matchSuccessInfo, @NonNull IAddMatchEffectListener listener) {
        if (!this.checkVaild(matchSuccessInfo)) {
            FeatureLog.i((String)TAG, (String)"addMatchSuccess checkVaild failed: %s", (Object[])new Object[]{matchSuccessInfo});
            return;
        }
        this.queryUserInfo(matchSuccessInfo, listener);
    }

    private void queryUserInfo(MatchSuccessInfo matchSuccessInfo, IAddMatchEffectListener listener) {
        if (!this.checkMatchUserInfoVaild(matchSuccessInfo)) {
            FeatureLog.i((String)TAG, (String)"queryUserInfo onSelected checkMatchUserInfoVaild error: left: %s  right: %s", (Object[])new Object[]{matchSuccessInfo.getLeftUid(), matchSuccessInfo.getRightUid()});
            return;
        }
        YYTaskExecutor.postToMainThread(() -> this.realAddMatchSuccess(matchSuccessInfo, listener));
    }

    private void realAddMatchSuccess(MatchSuccessInfo matchSuccessInfo, IAddMatchEffectListener listener) {
        if (this.isFinish) {
            FeatureLog.i((String)TAG, (String)"realAddMatchSuccess but finish", (Object[])new Object[0]);
            return;
        }
        DResource resource = null;
        long totalCharmValue = matchSuccessInfo.getCharmValue();
        if (totalCharmValue <= 0L) {
            int index = matchSuccessInfo.getRandomNumber() % this.oldSvgaPath.length;
            resource = this.oldSvgaPath[index];
        } else {
            resource = this.parseMatchInfo(matchSuccessInfo);
        }
        matchSuccessInfo.setSvgaKey(resource);
        this.matchSuccessInfoLinkedList.addLast(matchSuccessInfo);
        listener.onSuccess(matchSuccessInfo);
    }

    private DResource parseMatchInfo(@NonNull MatchSuccessInfo info) {
        DResource resource;
        MatchEffectLevel level = info.getMatchEffectLevel();
        switch (level) {
            case PRIMARY: {
                resource = DR.sv_pick_me_match_4;
                break;
            }
            case MEDIUM: {
                resource = DR.sv_pick_me_match_5;
                break;
            }
            case ULTIMATE: {
                resource = DR.sv_pick_me_match_6;
                break;
            }
            default: {
                int index = info.getRandomNumber() % this.svgaPath.length;
                resource = this.svgaPath[index];
            }
        }
        return resource;
    }

    public MatchSuccessInfo consumeMatchUserInfo() {
        if (this.matchSuccessInfoLinkedList.size() <= 0) {
            return null;
        }
        return this.matchSuccessInfoLinkedList.removeFirst();
    }

    public void clearMatchUserInfoEffect() {
        FeatureLog.i((String)TAG, (String)"clearMatchUserInfoEffect", (Object[])new Object[0]);
        this.isFinish = true;
        this.matchSuccessInfoLinkedList.clear();
    }

    private boolean checkVaild(MatchSuccessInfo matchSuccessInfo) {
        if (matchSuccessInfo == null) {
            return false;
        }
        return matchSuccessInfo.getLeftUid() > 0L && matchSuccessInfo.getRightUid() > 0L;
    }

    private boolean checkMatchUserInfoVaild(MatchSuccessInfo matchSuccessInfo) {
        if (matchSuccessInfo == null) {
            return false;
        }
        return matchSuccessInfo.getLeftUser() != null && matchSuccessInfo.getRightUser() != null;
    }
}

