/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.business.manager;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.base.logger.MLog;
import com.yy.hiyo.channel.plugins.pickme.base.PickMeContext;
import com.yy.hiyo.channel.plugins.pickme.business.base.ILifecycleObserver;
import com.yy.hiyo.channel.plugins.pickme.business.manager.BaseManager;
import com.yy.hiyo.channel.plugins.pickme.business.manager.ILifecycleManager;
import com.yy.hiyo.channel.plugins.pickme.common.PickMeEvent;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoNotifyHandler;
import com.yy.hiyo.channel.plugins.pickme.model.base.IProtoService;
import com.yy.hiyo.channel.plugins.pickme.model.base.IResCallback;
import com.yy.hiyo.channel.plugins.pickme.model.base.SimpleProtoNotifyHandler;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LifecycleManager
extends BaseManager
implements ILifecycleManager,
ILifecycleObserver {
    private static final String TAG = "FTPickMe#LifecycleManager";
    protected long mStatusUpdateTime = 0L;
    protected final MutableLiveData<Integer> mStatus = new MutableLiveData();
    protected final MutableLiveData<Boolean> mStartChooseRequesting = new MutableLiveData();
    protected final MutableLiveData<Boolean> mStartPublishRequesting = new MutableLiveData();
    protected final MutableLiveData<Boolean> mNewRoundRequesting = new MutableLiveData();
    protected final List<ILifecycleObserver> mLifecycleObservers = new LinkedList<ILifecycleObserver>();
    private IProtoNotifyHandler mNotifyHandler = new SimpleProtoNotifyHandler(){

        @Override
        public void onStartIntroduceNotify() {
            if (LifecycleManager.this.mStatus.getValue() != null && (Integer)LifecycleManager.this.mStatus.getValue() == 3) {
                LifecycleManager.this.sendEvent(PickMeEvent.ON_PRE_NEW_ROUND_START);
            }
            LifecycleManager.this.updateStatus(4);
        }

        @Override
        public void onStartSelectNotify() {
            if (!LifecycleManager.this.mContext.isNewPickMe() && LifecycleManager.this.mStatus.getValue() != null && (Integer)LifecycleManager.this.mStatus.getValue() == 3) {
                LifecycleManager.this.sendEvent(PickMeEvent.ON_PRE_NEW_ROUND_START);
            }
            LifecycleManager.this.updateStatus(1);
        }

        @Override
        public void onPublishStartNotify() {
            LifecycleManager.this.updateStatus(2);
        }
    };

    public LifecycleManager(@NotNull PickMeContext context, @NotNull IProtoService protoService) {
        super(context, protoService);
    }

    @Override
    public LiveData<Integer> getStatus() {
        return this.mStatus;
    }

    @Override
    public long getStatusUpdateTime() {
        return this.mStatusUpdateTime;
    }

    @Override
    public void addLifecycleObserver(ILifecycleObserver observer) {
        if (observer == null) {
            return;
        }
        this.mLifecycleObservers.add(observer);
    }

    @Override
    public void removeLifecycleObserver(ILifecycleObserver observer) {
        if (observer == null) {
            return;
        }
        this.mLifecycleObservers.remove(observer);
    }

    @Override
    public void initStatus(int status) {
        MLog.info((Object)TAG, (String)"initStatus, status=%d", (Object[])new Object[]{status});
        this.updateStatus(status);
    }

    @Override
    public void startNewRound() {
        MLog.info((Object)TAG, (String)"startNewRound", (Object[])new Object[0]);
        if (this.mNewRoundRequesting.getValue() != null && ((Boolean)this.mNewRoundRequesting.getValue()).booleanValue()) {
            MLog.error((Object)TAG, (String)"startNewRound, but new round requesting", (Object[])new Object[0]);
            return;
        }
        this.mNewRoundRequesting.setValue((Object)true);
        this.mProtoService.startNewRound(new IResCallback(){

            @Override
            public void onSuccess() {
                MLog.info((Object)LifecycleManager.TAG, (String)"startNewRound success", (Object[])new Object[0]);
                LifecycleManager.this.mNewRoundRequesting.setValue((Object)false);
            }

            @Override
            public void onFailure(long code, String msg) {
                MLog.error((Object)LifecycleManager.TAG, (String)"startNewRound failed, code=%d, msg=%s", (Object[])new Object[]{code, msg});
                LifecycleManager.this.mNewRoundRequesting.setValue((Object)false);
            }
        });
    }

    @Override
    public void startChoose() {
        MLog.info((Object)TAG, (String)"startChoose", (Object[])new Object[0]);
        if (this.mStartChooseRequesting.getValue() != null && ((Boolean)this.mStartChooseRequesting.getValue()).booleanValue()) {
            MLog.error((Object)TAG, (String)"startChoose,but start choose requesting.", (Object[])new Object[0]);
            return;
        }
        this.mStartChooseRequesting.setValue((Object)true);
        this.mProtoService.startSelectFriend(new IResCallback(){

            @Override
            public void onSuccess() {
                MLog.info((Object)LifecycleManager.TAG, (String)"startChoose success.", (Object[])new Object[0]);
                LifecycleManager.this.mStartChooseRequesting.setValue((Object)false);
            }

            @Override
            public void onFailure(long code, String msg) {
                MLog.error((Object)LifecycleManager.TAG, (String)"startChoose failed,code: %s , msg: %s", (Object[])new Object[]{code, msg});
                LifecycleManager.this.mStartChooseRequesting.setValue((Object)false);
            }
        });
    }

    @Override
    public void startPublish() {
        MLog.info((Object)TAG, (String)"startPublish", (Object[])new Object[0]);
        if (this.mStartPublishRequesting.getValue() != null && ((Boolean)this.mStartPublishRequesting.getValue()).booleanValue()) {
            MLog.error((Object)TAG, (String)"startPublish, but start publish requesting", (Object[])new Object[0]);
            return;
        }
        this.mStartPublishRequesting.setValue((Object)true);
        this.mProtoService.startPublish(new IResCallback(){

            @Override
            public void onSuccess() {
                MLog.info((Object)LifecycleManager.TAG, (String)"startPublish success", (Object[])new Object[0]);
                LifecycleManager.this.mStartPublishRequesting.setValue((Object)false);
            }

            @Override
            public void onFailure(long code, String msg) {
                MLog.error((Object)LifecycleManager.TAG, (String)"startPublish failed, code=%d, msg=%s", (Object[])new Object[]{code, msg});
                LifecycleManager.this.mStartPublishRequesting.setValue((Object)false);
            }
        });
    }

    @Override
    public void enterFinishedStatus() {
        this.updateStatus(3);
    }

    @Override
    public void close() {
        MLog.info((Object)TAG, (String)"close", (Object[])new Object[0]);
        this.updateStatus(0);
    }

    private void updateStatus(int status) {
        if (!this.checkStatusValid(status)) {
            return;
        }
        this.mStatusUpdateTime = System.currentTimeMillis();
        this.mStatus.setValue((Object)status);
        switch (status) {
            case 0: {
                this.onDestroy();
                break;
            }
            case 4: {
                this.onIntroduce();
                break;
            }
            case 1: {
                this.onChoose();
                break;
            }
            case 2: {
                this.onPublish();
                break;
            }
            case 3: {
                this.onFinish();
                break;
            }
        }
    }

    private boolean checkStatusValid(int status) {
        return this.mStatus.getValue() == null || status != (Integer)this.mStatus.getValue();
    }

    @Override
    public void onServiceInit() {
        super.onServiceInit();
        this.mStartChooseRequesting.setValue((Object)false);
        this.mNewRoundRequesting.setValue((Object)false);
        this.mStartPublishRequesting.setValue((Object)false);
        this.mProtoService.addNotifyHandler(this.mNotifyHandler);
    }

    @Override
    public void onServiceDestroy() {
        super.onServiceDestroy();
        this.mProtoService.removeNotifyHandler(this.mNotifyHandler);
        this.mLifecycleObservers.clear();
    }

    @Override
    public void onIntroduce() {
        MLog.info((Object)TAG, (String)"onIntroduce", (Object[])new Object[0]);
        for (ILifecycleObserver callback : this.mLifecycleObservers) {
            callback.onIntroduce();
        }
    }

    @Override
    public void onChoose() {
        MLog.info((Object)TAG, (String)"onChoose", (Object[])new Object[0]);
        for (ILifecycleObserver callback : this.mLifecycleObservers) {
            callback.onChoose();
        }
    }

    @Override
    public void onPublish() {
        MLog.info((Object)TAG, (String)"onPublish", (Object[])new Object[0]);
        for (ILifecycleObserver callback : this.mLifecycleObservers) {
            callback.onPublish();
        }
    }

    @Override
    public void onFinish() {
        MLog.info((Object)TAG, (String)"onFinish", (Object[])new Object[0]);
        for (ILifecycleObserver callback : this.mLifecycleObservers) {
            callback.onFinish();
        }
    }

    @Override
    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy", (Object[])new Object[0]);
        for (ILifecycleObserver callback : this.mLifecycleObservers) {
            callback.onDestroy();
        }
    }
}

