/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.pickme.ui.base;

import android.os.Bundle;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import com.yy.hiyo.channel.plugins.pickme.base.IEventHandler;
import com.yy.hiyo.channel.plugins.pickme.ui.base.IPickMeViewController;
import com.yy.hiyo.mvp.base.SimpleLifeCycleOwner;
import java.util.LinkedList;
import java.util.List;

public abstract class AbsPickMeViewController
implements IPickMeViewController {
    private SimpleLifeCycleOwner mLifecycleOwner;
    private List<IEventHandler> mViewEventHandlers = new LinkedList<IEventHandler>();

    public AbsPickMeViewController() {
        this.mLifecycleOwner = new SimpleLifeCycleOwner();
    }

    protected LifecycleOwner getLifecycleOwner() {
        return this.mLifecycleOwner;
    }

    @Override
    public void addEventHandler(IEventHandler handler) {
        if (handler == null) {
            return;
        }
        this.mViewEventHandlers.add(handler);
    }

    @Override
    public void removeEventHandler(IEventHandler handler) {
        if (handler == null) {
            return;
        }
        this.mViewEventHandlers.remove(handler);
    }

    @Override
    public void sendEvent(int eventId) {
        this.sendEvent(eventId, null);
    }

    @Override
    public void sendEvent(int eventId, Bundle data) {
        for (IEventHandler handler : this.mViewEventHandlers) {
            handler.handleEvent(eventId, data);
        }
    }

    @Override
    public void resume() {
        this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_START);
        this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_RESUME);
    }

    @Override
    public void pause() {
        this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_PAUSE);
        this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_STOP);
    }

    @Override
    public void clear() {
        this.mLifecycleOwner.onEvent(Lifecycle.Event.ON_DESTROY);
        this.mViewEventHandlers.clear();
    }
}

