/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.hago.party.imp;

import android.app.Application;
import android.content.Context;
import com.duowan.hago.party.api.ISdkSupport;
import com.duowan.hago.party.api.aab.IAabSupport;
import com.duowan.hago.party.api.aab.IBundleDownloadListener;
import com.yy.appbase.aab.IAabApi;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public class HagoPartyBridge {
    private static final String TAG = "HagoPartyBridge";
    private static volatile boolean hadInit = false;

    public static void init(Application context, String appId, ISdkSupport supportFun) {
        HagoPartyBridge.initHago(context, appId, supportFun);
    }

    public static void activityInit(Application context) {
        if (hadInit) {
            return;
        }
        try {
            HagoPartyBridge.reflectInit(context, null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void initHago(Application context, String appId, ISdkSupport supportFun) {
        try {
            IAabApiImp aabApi = new IAabApiImp(supportFun.getAABSupport());
            HagoPartyBridge.reflectInit(context, aabApi);
            hadInit = true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static void reflectInit(Application context, IAabApi aabApi) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> cls = Class.forName("com.yy.hiyo.HagoPartySdkApplication");
        Method method = cls.getDeclaredMethod("onCreate", Application.class, IAabApi.class);
        method.invoke(null, context, aabApi);
    }

    private static class IAabApiImp
    implements IAabApi {
        private IAabSupport aabSupport;
        private Map<String, List<IAabApi.IBundleListener>> listeners = new ConcurrentHashMap<String, List<IAabApi.IBundleListener>>();
        private IBundleDownloadListener ntListener = new IBundleDownloadListener(){

            public void onBundleDownloadSuccess(@NotNull String name) {
                MLog.info((Object)HagoPartyBridge.TAG, (String)"onBundleDownloadSuccess name: %s", (Object[])new Object[]{name});
                List list = (List)listeners.remove(name);
                if (list != null && !list.isEmpty()) {
                    for (IAabApi.IBundleListener listener : list) {
                        listener.onBundleInstallSuccess(name);
                    }
                }
                YYTaskExecutor.postToMainThread(() -> aabSupport.unRegisterBundleDownloadListener(name, ntListener));
            }

            public void onBundleDownloadFail(@NotNull String name, int errorCode, @NotNull String errorMsg) {
                MLog.info((Object)HagoPartyBridge.TAG, (String)"onBundleDownloadSuccess name: %s, errorCode: %d, errorMsg: %s", (Object[])new Object[]{name, errorCode, errorMsg});
                List list = (List)listeners.get(name);
                if (list != null && !list.isEmpty()) {
                    for (IAabApi.IBundleListener listener : list) {
                        listener.onBundleInstallFail(name, errorCode, errorMsg);
                    }
                }
            }
        };

        public IAabApiImp(IAabSupport aabSupport) {
            this.aabSupport = aabSupport;
        }

        public boolean isBundleInstall(@NotNull String name) {
            return this.aabSupport.isBundleDownload(name);
        }

        public void registerBundleListener(@NotNull String name, @NotNull IAabApi.IBundleListener listener) {
            if (this.isBundleInstall(name)) {
                listener.onBundleInstallSuccess(name);
                return;
            }
            List<IAabApi.IBundleListener> list = this.listeners.get(name);
            if (list == null || list.isEmpty()) {
                this.aabSupport.registerBundleDownloadListener(name, this.ntListener);
                list = new CopyOnWriteArrayList<IAabApi.IBundleListener>();
                list.add(listener);
                this.listeners.put(name, list);
            } else if (!list.contains(listener)) {
                list.add(listener);
            } else {
                MLog.info((Object)HagoPartyBridge.TAG, (String)"\u91cd\u590dregister listener", (Object[])new Object[0]);
            }
        }

        public void unRegisterListener(@NotNull String name, @NotNull IAabApi.IBundleListener listener) {
            List<IAabApi.IBundleListener> list = this.listeners.get(name);
            if (list == null || list.isEmpty()) {
                this.aabSupport.unRegisterBundleDownloadListener(name, this.ntListener);
                list = new CopyOnWriteArrayList<IAabApi.IBundleListener>();
                return;
            }
            list.remove(listener);
            if (list.isEmpty()) {
                this.aabSupport.registerBundleDownloadListener(name, this.ntListener);
                this.listeners.remove(name);
            }
        }

        public void splitCompatInstallActivity(@NotNull Context context) {
            this.aabSupport.splitCompatInstallActivity(context);
        }

        public void splitCompatInstall(@NotNull Context context) {
            this.aabSupport.splitCompatInstall(context);
        }
    }
}

