/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.hago.party.imp.login;

import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;
import com.duowan.hago.party.api.HagoParty;
import com.duowan.hago.party.imp.R;
import com.duowan.hago.party.imp.login.LoginImpl;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.loginrequest.BaseLoginRequestManager;
import com.yy.hiyo.loginrequest.IGuestLoginRequestCallBack;
import java.util.ArrayList;

public class LoginChecker {
    public static final String LOGIN_TAG = "HagoParty_Login";
    private static boolean showDialog = false;
    private static DialogLinkManager dialogLinkManager;
    private static boolean sIsLoginChecking;
    private static boolean sCanceledByUser;
    private static BaseLoginRequestManager sBaseLoginRequestManager;
    private static INotify sLoginNotify;
    private static ArrayList<Runnable> sCallbackCommands;
    private static ArrayList<Runnable> sFailCallbackCommands;

    public static void ensureLogin(Context activity, Runnable callbackCommand) {
        LoginChecker.ensureLogin(activity, callbackCommand, null);
    }

    public static void ensureLogin(final Context activity, Runnable callbackCommand, final Runnable failCallbackCommand) {
        if (sLoginNotify == null && NotificationCenter.getGlobalInstance().isInited()) {
            sLoginNotify = new INotify(){

                public void notify(Notification notification) {
                    LoginChecker.handleLoginSuccess();
                }
            };
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, sLoginNotify);
        }
        if (AccountModel.getInstance().getAccountInfo().uuid > 0L) {
            callbackCommand.run();
        } else if (!sIsLoginChecking) {
            sCallbackCommands.add(callbackCommand);
            sFailCallbackCommands.add(failCallbackCommand);
            LoginChecker.mackCheckStart(activity);
            MLog.error((Object)LOGIN_TAG, (String)"need login first!", (Object[])new Object[0]);
            ((LoginImpl)HagoParty.INSTANCE.login()).loginGuest(new IGuestLoginRequestCallBack(){

                public void onSuccess(AccountInfo data) {
                    LoginChecker.handleLoginSuccess();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onError(String errorCode, String errorDescription, String exceptionDue) {
                    MLog.info((Object)LoginChecker.LOGIN_TAG, (String)"loginGuest fail:%s, msg:%s!", (Object[])new Object[]{errorCode, errorDescription});
                    if (failCallbackCommand == null && activity != null) {
                        Toast.makeText((Context)activity, (CharSequence)ResourceUtils.getString((int)R.string.tips_unknown_error), (int)0).show();
                    }
                    ArrayList arrayList = sFailCallbackCommands;
                    synchronized (arrayList) {
                        if (sFailCallbackCommands.size() > 0) {
                            for (Runnable item : sFailCallbackCommands) {
                                item.run();
                            }
                            sFailCallbackCommands.clear();
                        }
                    }
                    LoginChecker.markCheckEnd();
                }
            });
        } else {
            MLog.error((Object)LOGIN_TAG, (String)"is LoginChecking, not handle this request!", (Object[])new Object[0]);
        }
    }

    private static void mackCheckStart(Context activity) {
        sIsLoginChecking = true;
        if (showDialog) {
            dialogLinkManager = new DialogLinkManager(activity);
            ProgressDialog dialog = new ProgressDialog("", true, true, null, new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialogInterface) {
                    MLog.info((Object)LoginChecker.LOGIN_TAG, (String)"check login cancel by user!", (Object[])new Object[0]);
                    sCanceledByUser = true;
                }
            });
            dialogLinkManager.showDialog((BaseDialog)dialog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void markCheckEnd() {
        sIsLoginChecking = false;
        sCanceledByUser = false;
        ArrayList<Runnable> arrayList = sCallbackCommands;
        synchronized (arrayList) {
            sCallbackCommands.clear();
        }
        arrayList = sFailCallbackCommands;
        synchronized (arrayList) {
            sFailCallbackCommands.clear();
        }
        if (dialogLinkManager != null && dialogLinkManager.isDialogShowing()) {
            dialogLinkManager.dismissDialog();
            dialogLinkManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleLoginSuccess() {
        long uid = -1L;
        if (AccountModel.getInstance().getAccountInfo() != null) {
            uid = AccountModel.getInstance().getAccountInfo().uuid;
        }
        MLog.info((Object)LOGIN_TAG, (String)"loginGuest success account:%s", (Object[])new Object[]{String.valueOf(uid)});
        ArrayList<Runnable> arrayList = sCallbackCommands;
        synchronized (arrayList) {
            if (!sCanceledByUser && sCallbackCommands.size() > 0) {
                for (Runnable item : sCallbackCommands) {
                    item.run();
                }
                sCallbackCommands.clear();
            }
        }
        LoginChecker.markCheckEnd();
    }

    static {
        sIsLoginChecking = false;
        sCanceledByUser = false;
        sBaseLoginRequestManager = new BaseLoginRequestManager();
        sCallbackCommands = new ArrayList();
        sFailCallbackCommands = new ArrayList();
    }
}

