/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.multivideo.business.seat;

import android.app.Activity;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.bean.ISeatUser;
import com.yy.hiyo.channel.plugins.multivideo.business.seat.MultiVideoSeatCore;
import com.yy.hiyo.multivideo.MultiVideoSeatInfo;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/yy/hiyo/channel/plugins/multivideo/business/seat/MultiVideoSeatCore;", "", "()V", "mHasCameraPermission", "", "sortList", "", "User", "Lcom/yy/hiyo/channel/base/bean/ISeatUser;", "list", "updateSeatInfo", "", "mContext", "Landroid/app/Activity;", "seatInfo", "Lcom/yy/hiyo/multivideo/MultiVideoSeatInfo;", "needCheckPermission", "multivideo_release"})
public final class MultiVideoSeatCore {
    private boolean mHasCameraPermission;

    public final void updateSeatInfo(@NotNull Activity mContext, @NotNull MultiVideoSeatInfo seatInfo, boolean needCheckPermission) {
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
            Intrinsics.checkParameterIsNotNull((Object)seatInfo, (String)"seatInfo");
            if (needCheckPermission) {
                if (!this.mHasCameraPermission && PermissionHelper.hasCameraPermission((Activity)mContext)) {
                    this.mHasCameraPermission = true;
                }
                if (this.mHasCameraPermission) {
                    IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getInstance().getService(IKtvLiveServiceExtend.class);
                    if (iKtvLiveServiceExtend != null) {
                        iKtvLiveServiceExtend.updateMultipleVideo(seatInfo.getMicInfoList());
                    }
                }
            } else {
                IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getInstance().getService(IKtvLiveServiceExtend.class);
                if (iKtvLiveServiceExtend != null) {
                    iKtvLiveServiceExtend.updateMultipleVideo(seatInfo.getMicInfoList());
                }
            }
            IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getInstance().getService(IKtvLiveServiceExtend.class);
            if (iKtvLiveServiceExtend == null) break block6;
            iKtvLiveServiceExtend.updateMultiMicStatus(seatInfo.getMicStatusList());
        }
    }

    @NotNull
    public final <User extends ISeatUser> List<User> sortList(@NotNull List<? extends User> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        ArrayList<ISeatUser> sortList2 = new ArrayList<ISeatUser>(list.size());
        for (ISeatUser item : list) {
            if (item == null || item.uid() == 0L) continue;
            sortList2.add(item);
        }
        if (!FP.empty((Collection)sortList2)) {
            CollectionsKt.sortWith((List)sortList2, (Comparator)sortList.1.INSTANCE);
        }
        return sortList2;
    }
}

