/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.multivideo;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ColorUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.plugins.multivideo.MultiVideoManager;
import com.yy.hiyo.channel.plugins.multivideo.view.EmptySeatView;
import com.yy.hiyo.multivideo.IMultiVideoHandler;
import com.yy.hiyo.multivideo.IMultiVideoManager;
import com.yy.hiyo.multivideo.MultiVideoNotifyDef;
import com.yy.hiyo.multivideo.MultiVideoSeatInfo;
import com.yy.hiyo.voice.base.bean.VideoPositionWrapper;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IMultiVideoEventHandler;
import com.yy.hiyo.voice.base.channelvoice.MultiVideoConfig;
import com.yy.hiyo.voice.base.channelvoice.OnVideoLayoutChangeListener;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\f\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/yy/hiyo/channel/plugins/multivideo/MultiVideoManager;", "Lcom/yy/hiyo/multivideo/IMultiVideoManager;", "mContext", "Landroid/content/Context;", "mHandler", "Lcom/yy/hiyo/multivideo/IMultiVideoHandler;", "(Landroid/content/Context;Lcom/yy/hiyo/multivideo/IMultiVideoHandler;)V", "mEmptySeatView", "Lcom/yy/hiyo/channel/plugins/multivideo/view/EmptySeatView;", "mHasCameraPermission", "", "mVideoLayoutChangeListener", "com/yy/hiyo/channel/plugins/multivideo/MultiVideoManager$mVideoLayoutChangeListener$1", "Lcom/yy/hiyo/channel/plugins/multivideo/MultiVideoManager$mVideoLayoutChangeListener$1;", "onDestroy", "", "showInviteSitDownGuide", "stopInviteGuideAnim", "updateSeatInfo", "seatInfo", "Lcom/yy/hiyo/multivideo/MultiVideoSeatInfo;", "needCheckPermission", "Companion", "multivideo_release"})
public final class MultiVideoManager
implements IMultiVideoManager {
    private EmptySeatView mEmptySeatView;
    private boolean mHasCameraPermission;
    private mVideoLayoutChangeListener.1 mVideoLayoutChangeListener;
    private final Context mContext;
    private final IMultiVideoHandler mHandler;
    @NotNull
    public static final String TAG = "MultiVideoManager";
    public static final Companion Companion = new Companion(null);

    public void updateSeatInfo(@NotNull MultiVideoSeatInfo seatInfo, boolean needCheckPermission) {
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)seatInfo, (String)"seatInfo");
            if (needCheckPermission) {
                if (!this.mHasCameraPermission) {
                    Context context = this.mContext;
                    if (context == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
                    }
                    if (PermissionHelper.hasCameraPermission((Activity)((Activity)context))) {
                        this.mHasCameraPermission = true;
                    }
                }
                if (this.mHasCameraPermission) {
                    IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getInstance().getService(IKtvLiveServiceExtend.class);
                    if (iKtvLiveServiceExtend != null) {
                        iKtvLiveServiceExtend.updateMultipleVideo(seatInfo.getMicInfoList());
                    }
                }
            } else {
                IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getInstance().getService(IKtvLiveServiceExtend.class);
                if (iKtvLiveServiceExtend != null) {
                    iKtvLiveServiceExtend.updateMultipleVideo(seatInfo.getMicInfoList());
                }
            }
            IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getInstance().getService(IKtvLiveServiceExtend.class);
            if (iKtvLiveServiceExtend == null) break block8;
            iKtvLiveServiceExtend.updateMultiMicStatus(seatInfo.getMicStatusList());
        }
    }

    public void showInviteSitDownGuide() {
        block0: {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045525").put("function_id", "guide_invite_animation_show"));
            EmptySeatView emptySeatView = this.mEmptySeatView;
            if (emptySeatView == null) break block0;
            emptySeatView.showInviteSitDownGuide();
        }
    }

    public void stopInviteGuideAnim() {
        block0: {
            EmptySeatView emptySeatView = this.mEmptySeatView;
            if (emptySeatView == null) break block0;
            emptySeatView.stopInviteGuideAnim();
        }
    }

    public void onDestroy() {
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)MultiVideoNotifyDef.INSTANCE.getMULTIVIDEO_LEAVE_ROOM()));
        IServiceManager iServiceManager = ServiceManagerProxy.getInstance();
        if (iServiceManager != null && (iServiceManager = (IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)) != null) {
            iServiceManager.unRegisterMultiVideoLayoutChangeListener((OnVideoLayoutChangeListener)this.mVideoLayoutChangeListener);
        }
        EmptySeatView emptySeatView = this.mEmptySeatView;
        if (emptySeatView != null) {
            emptySeatView.destroy();
        }
        this.mEmptySeatView = null;
    }

    public MultiVideoManager(@NotNull Context mContext, @NotNull IMultiVideoHandler mHandler) {
        block3: {
            IServiceManager iServiceManager;
            IServiceManager iServiceManager2;
            Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
            Intrinsics.checkParameterIsNotNull((Object)mHandler, (String)"mHandler");
            this.mContext = mContext;
            this.mHandler = mHandler;
            this.mVideoLayoutChangeListener = new OnVideoLayoutChangeListener(this){
                final /* synthetic */ MultiVideoManager this$0;

                public void onVideoLayoutChange(@NotNull List<VideoPositionWrapper> layoutInfo) {
                    block5: {
                        Intrinsics.checkParameterIsNotNull(layoutInfo, (String)"layoutInfo");
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)"MultiVideoManager", (String)("onVideoLayoutChange: " + layoutInfo), (Object[])new Object[0]);
                        }
                        if (MultiVideoManager.access$getMEmptySeatView$p(this.this$0) == null) {
                            MultiVideoManager.access$setMEmptySeatView$p(this.this$0, new EmptySeatView(MultiVideoManager.access$getMContext$p(this.this$0), MultiVideoManager.access$getMHandler$p(this.this$0).getOwnerUid() == AccountUtil.getUid(), MultiVideoManager.access$getMHandler$p(this.this$0).isMeAnchor()));
                            EmptySeatView emptySeatView = MultiVideoManager.access$getMEmptySeatView$p(this.this$0);
                            if (emptySeatView == null) {
                                Intrinsics.throwNpe();
                            }
                            emptySeatView.setOnEmptySeatViewListener(new EmptySeatView.IEmptySeatViewListener(this){
                                final /* synthetic */ mVideoLayoutChangeListener.1 this$0;

                                public void onClickJoin() {
                                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045525").put("function_id", "self_seat_click"));
                                    MultiVideoManager.access$getMHandler$p(this.this$0.this$0).joinSeat();
                                }

                                public void onClickShared() {
                                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20045525").put("function_id", "invite_seat_click"));
                                    MultiVideoManager.access$getMHandler$p(this.this$0.this$0).openSharedPanel();
                                }

                                @NotNull
                                public String getRandomAvatar() {
                                    return MultiVideoManager.access$getMHandler$p(this.this$0.this$0).getRandomAvatar();
                                }
                                {
                                    this.this$0 = $outer;
                                }
                            });
                            if (MultiVideoManager.access$getMHandler$p(this.this$0).getCoverContainer() != null) {
                                ViewGroup viewGroup = MultiVideoManager.access$getMHandler$p(this.this$0).getCoverContainer();
                                if (viewGroup != null) {
                                    viewGroup.addView((View)MultiVideoManager.access$getMEmptySeatView$p(this.this$0));
                                }
                            }
                        }
                        EmptySeatView emptySeatView = MultiVideoManager.access$getMEmptySeatView$p(this.this$0);
                        if (emptySeatView == null) break block5;
                        emptySeatView.updateSeatList(layoutInfo, MultiVideoManager.access$getMHandler$p(this.this$0).isAllSeatLock());
                    }
                }
                {
                    this.this$0 = $outer;
                }
            };
            if (this.mHandler.getMultiVideoContainer() != null && (iServiceManager2 = ServiceManagerProxy.getInstance()) != null && (iServiceManager2 = (IKtvLiveServiceExtend)iServiceManager2.getService(IKtvLiveServiceExtend.class)) != null) {
                ViewGroup viewGroup = this.mHandler.getMultiVideoContainer();
                if (viewGroup == null) {
                    Intrinsics.throwNpe();
                }
                if (viewGroup == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout");
                }
                iServiceManager2.initMultipleVideoContainer((FrameLayout)viewGroup, BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)ColorUtils.parseColor((String)"#530DBF")), new IMultiVideoEventHandler(){

                    public long getOwnerUid() {
                        return mHandler.getOwnerUid();
                    }

                    public void onVideoClick(long uid) {
                        mHandler.showProfileCard(uid);
                    }

                    @NotNull
                    public String getChannelId() {
                        return mHandler.getChannelId();
                    }
                }, this.mHandler.getAudioSeatContainer(), new MultiVideoConfig(false, true, this.mHandler.getChannelId()));
            }
            if ((iServiceManager = ServiceManagerProxy.getInstance()) == null || (iServiceManager = (IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class)) == null) break block3;
            iServiceManager.registerMultiVideoLayoutChangeListener((OnVideoLayoutChangeListener)this.mVideoLayoutChangeListener, true);
        }
    }

    public static final /* synthetic */ EmptySeatView access$getMEmptySeatView$p(MultiVideoManager $this) {
        return $this.mEmptySeatView;
    }

    public static final /* synthetic */ void access$setMEmptySeatView$p(MultiVideoManager $this, EmptySeatView emptySeatView) {
        $this.mEmptySeatView = emptySeatView;
    }

    public static final /* synthetic */ Context access$getMContext$p(MultiVideoManager $this) {
        return $this.mContext;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/plugins/multivideo/MultiVideoManager$Companion;", "", "()V", "TAG", "", "multivideo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

