/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.share;

import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.plugins.micup.MicUpStatisHelper;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.hiyo.share.base.IShareTemplate;
import com.yy.hiyo.share.base.IShareViewProvider;
import com.yy.hiyo.share.base.dataprovider.DataProgressListener;
import com.yy.hiyo.share.base.dataprovider.IImageLinkDataProvider;
import com.yy.hiyo.share.base.template.ImageLinkShareTemplate;
import org.jetbrains.annotations.NotNull;

public class MicUpShareHelper
implements ISharePage {
    private static final String SHARE_KEY = "micup_result";
    private static final String SHARE_URL_TEST = "https://test.ihago.net/a/micup-sharepage/index.html";
    private static final String SHARE_URL = "https://www.ihago.net/a/micup-sharepage/index.html";
    private static final String SHARE_TEXT = ResourceUtils.getString((int)R.string.short_title_mic_up_together);
    private static final String URL_PARAM_USER_NICK = "userNick";
    private static final String URL_PARAM_UID = "uid";
    private String mRoomId;
    private int mRoleType;
    private IServiceManager mServiceManager;
    private IShareTemplate mShareTemplate;
    private IImageLinkDataProvider mShareDataProvider;
    private DialogLinkManager mDialogLinkManager;
    private UserInfoKS mShareUserInfo;
    private boolean mCanShare = false;

    public MicUpShareHelper(@NotNull IServiceManager serviceManager) {
        this.mServiceManager = serviceManager;
        this.mShareTemplate = new ImageLinkShareTemplate();
        this.mShareDataProvider = ((IIntlShareService)ServiceManagerProxy.getService(IIntlShareService.class)).createAImageLinkDataProvider(SHARE_KEY);
        this.mShareDataProvider.setBaseUrl(this.getShareUrl());
        this.mShareDataProvider.setBaseText(SHARE_TEXT);
        this.mShareDataProvider.setDataBuildProgressListener(new DataProgressListener(){

            public void onStart() {
                MicUpShareHelper.this.showLoading();
            }

            public void onEnd() {
                MicUpShareHelper.this.hideLoading();
            }
        });
    }

    public void setRoomId(String roomId) {
        this.mRoomId = roomId;
    }

    public void setRoleType(int roleType) {
        this.mRoleType = roleType;
    }

    public void setCanShare(boolean canShare) {
        this.mCanShare = canShare;
    }

    public void setShareViewProvider(@NotNull IShareViewProvider shareViewProvider) {
        this.mShareDataProvider.setShareViewProvider(shareViewProvider);
    }

    public void setShareUserInfo(UserInfoKS userInfo) {
        this.mShareUserInfo = userInfo;
        this.mShareDataProvider.addUrlParam(URL_PARAM_UID, "" + this.mShareUserInfo.uid);
    }

    public void setDialogLinkManager(DialogLinkManager dialogLinkManager) {
        this.mDialogLinkManager = dialogLinkManager;
    }

    public void share(int channelId) {
        if (channelId == 0) {
            this.reportShareMoreClick();
        } else {
            this.reportShareChannelClick(channelId);
        }
        if (!this.mCanShare) {
            return;
        }
        if (this.mServiceManager == null || this.mServiceManager.getService(IIntlShareService.class) == null) {
            return;
        }
        this.mShareDataProvider.waitDataReady(shareBundle -> ((IIntlShareService)this.mServiceManager.getService(IIntlShareService.class)).share(channelId, shareBundle, this.mShareTemplate));
    }

    private void showLoading() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
    }

    private void hideLoading() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        this.mDialogLinkManager.dismissDialog();
    }

    private String getShareUrl() {
        if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Product) {
            return SHARE_URL;
        }
        return SHARE_URL_TEST;
    }

    public void showShareBottomDialog() {
        if (this.mServiceManager == null) {
            return;
        }
        ((IIntlShareService)this.mServiceManager.getService(IIntlShareService.class)).showShareBottomDialog((ISharePage)this, channelId -> this.share(channelId), dialog -> MicUpStatisHelper.reportSharePopClose(this.mRoomId));
        MicUpStatisHelper.reportSharePopShow(this.mRoomId);
    }

    public String getPageName() {
        return "mic_up_result_page";
    }

    private void reportShareChannelClick(int channelId) {
        int shareAppType = channelId == 5 ? 2 : (channelId == 2 ? 1 : (channelId == 3 ? 3 : (channelId == 4 ? 4 : 9)));
        MicUpStatisHelper.reportShareAppClick(this.mRoomId, this.mRoleType, shareAppType);
    }

    private void reportShareMoreClick() {
        MicUpStatisHelper.reportMoreClick(this.mRoomId);
    }
}

