/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel.countdown;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.callback.SimpleSVGACallback;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.hiyo.channel.plugins.micup.DR;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpView;
import com.yy.hiyo.channel.plugins.micup.panel.countdown.ICountDownCallback;
import com.yy.hiyo.dyres.api.DyResLoader;

public class MicUpCountDownView
extends YYFrameLayout
implements IMicUpView {
    private static final String TAG = "MicUpCountDownView";
    private SVGAImageView mSVGAImageView;

    public MicUpCountDownView(Context context) {
        super(context);
        this.createView(context);
    }

    public MicUpCountDownView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public MicUpCountDownView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        this.mSVGAImageView = new SVGAImageView(context);
        this.mSVGAImageView.setLoopCount(1);
        this.mSVGAImageView.setFillMode(SVGAImageView.FillMode.Forward);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(ResolutionUtils.dip2Px((float)140.0f), ResolutionUtils.dip2Px((float)122.0f), 17);
        this.addView((View)this.mSVGAImageView, (ViewGroup.LayoutParams)layoutParams);
    }

    @UiThread
    public void startCountDown(final @Nullable ICountDownCallback callback) {
        if (this.mSVGAImageView != null) {
            this.mSVGAImageView.setCallback((SVGACallback)new SimpleSVGACallback(){

                public void onFinished() {
                    if (callback != null) {
                        callback.finish();
                    }
                }
            });
            DyResLoader.INSTANCE.loadSvga(this.mSVGAImageView, DR.mic_up_count_down, new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                    MicUpCountDownView.this.mSVGAImageView.startAnimation();
                }

                public void onFailed(Exception e) {
                    MLog.error((Object)MicUpCountDownView.TAG, (String)"load svga failed: %s", (Throwable)e, (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread(() -> {
                        if (callback != null) {
                            callback.finish();
                        }
                    }, (long)3000L);
                }
            });
        }
    }

    @UiThread
    public void stopCountDown() {
        if (this.mSVGAImageView != null) {
            this.mSVGAImageView.stopAnimation();
        }
    }

    @Override
    public void onDestroy() {
    }
}

