/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.share.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;
import com.yy.hiyo.share.base.ViewRenderTaskCallback;
import org.jetbrains.annotations.NotNull;

public class PlayerShareCardView
extends YYRelativeLayout {
    private CircleImageView mIvAvatar;
    private TextView mTvNick;
    private TextView mTvDesc;
    private TextView mTvRanking;
    private TextView mTvGetMic;
    private TextView mTvScore;

    public PlayerShareCardView(Context context) {
        super(context);
        this.createView();
    }

    public PlayerShareCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView();
    }

    public PlayerShareCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView();
    }

    private void createView() {
        PlayerShareCardView.inflate((Context)this.getContext(), (int)R.layout.view_player_share_card_channel, (ViewGroup)this);
        this.mIvAvatar = (CircleImageView)this.findViewById(R.id.iv_avatar);
        this.mTvNick = (TextView)this.findViewById(R.id.tv_nick);
        this.mTvDesc = (TextView)this.findViewById(R.id.tv_desc);
        this.mTvRanking = (TextView)this.findViewById(R.id.tv_ranking_num);
        this.mTvGetMic = (TextView)this.findViewById(R.id.tv_get_mic_num);
        this.mTvScore = (TextView)this.findViewById(R.id.tv_score_num);
        this.setBackgroundResource(R.drawable.bg_mic_up_player_share);
    }

    public void setUserInfo(@NotNull UserInfoKS userInfo, final ViewRenderTaskCallback avatarLoadCallback) {
        this.mTvNick.setText((CharSequence)userInfo.nick);
        String avatarUrl = userInfo.avatar + YYImageUtils.getThumbnailPostfix((int)75);
        ImageLoader.loadImage((ImageView)this.mIvAvatar, (String)avatarUrl, (int)0, (int)AvatarUtils.getDefaultAvatar((int)userInfo.sex), (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                if (avatarLoadCallback != null) {
                    avatarLoadCallback.onRenderTaskFinish();
                }
            }
        });
    }

    public void setResultData(ResultInfo resultInfo) {
        if (resultInfo == null) {
            return;
        }
        this.mTvRanking.setText((CharSequence)("" + resultInfo.rank));
        this.mTvGetMic.setText((CharSequence)("" + resultInfo.micNum));
        this.mTvScore.setText((CharSequence)("" + resultInfo.score));
    }
}

