/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;
import com.yy.hiyo.channel.plugins.micup.impl.MicupDataService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.ihago.room.srv.micup.ExtendKey;
import net.ihago.room.srv.micup.GetResultsReq;
import net.ihago.room.srv.micup.GetResultsRes;
import net.ihago.room.srv.micup.PlayerInfo;

public final class MicUpRepository {
    public void fetchResult(@NonNull String roomId, int term, final OnResultCallback callback) {
        List<ExtendKey> extendKeys = Arrays.asList(ExtendKey.Avatar, ExtendKey.Nick);
        GetResultsReq req = new GetResultsReq.Builder().keys(extendKeys).term(Integer.valueOf(term)).build();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetResultsRes>(){

            public void onResponse(@NonNull GetResultsRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    FeatureLog.e((String)"FTMicUpResult", (String)"fetch result error message == null.", (Object[])new Object[0]);
                    if (callback != null) {
                        callback.onFail();
                    }
                    return;
                }
                MicupDataService.checkResponseResult("fetchResult", message.res);
                FeatureLog.i((String)"FTMicUpResult", (String)"proto send rpc had received response: %s", (Object[])new Object[]{!message.res.__isDefaultInstance()});
                List playerInfoList = message.players;
                if (FP.empty((Collection)playerInfoList)) {
                    FeatureLog.e((String)"FTMicUpResult", (String)"fetch result error playerInfoList is empty or null.", (Object[])new Object[0]);
                    if (callback != null) {
                        callback.onFail();
                    }
                    return;
                }
                ArrayList<ResultInfo> resultInfoList = new ArrayList<ResultInfo>(playerInfoList.size());
                int size = playerInfoList.size();
                for (int i = 0; i < size; ++i) {
                    PlayerInfo playerInfo = (PlayerInfo)playerInfoList.get(i);
                    ResultInfo resultInfo = new ResultInfo();
                    resultInfo.uid = playerInfo.uid;
                    resultInfo.avatar = playerInfo.extra.Avatar;
                    resultInfo.nick = playerInfo.extra.Nick;
                    resultInfo.rank = i + 1;
                    resultInfo.micNum = playerInfo.total;
                    resultInfo.score = playerInfo.score;
                    resultInfoList.add(resultInfo);
                }
                if (callback != null) {
                    callback.onSuccess(resultInfoList);
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                FeatureLog.e((String)"FTMicUpResult", (String)"proto send rpc onError: %s,code: %s", (Object[])new Object[]{reason, code});
                if (callback != null) {
                    callback.onFail();
                }
            }
        });
    }

    public static interface OnResultCallback {
        public void onSuccess(List<ResultInfo> var1);

        public void onFail();
    }
}

