/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel.sing;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.UiThread;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.plugins.micup.DR;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpView;
import com.yy.hiyo.channel.plugins.micup.panel.MicUpUICallback;
import com.yy.hiyo.channel.plugins.micup.panel.widget.MicUpHeartView;
import com.yy.hiyo.channel.plugins.micup.panel.widget.MicUpPanelCircleView;
import com.yy.hiyo.dyres.api.DyResLoader;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class MicUpSingView
extends YYConstraintLayout
implements View.OnClickListener,
IMicUpView {
    private CountDownTimer mCountDownTimer;
    private MicUpUICallback mUICallback;
    private YYTextView mFirstLeadSingView;
    private YYTextView mSecondLeadSingView;
    private MicUpHeartView mMicUpHeartView;
    private YYTextView mFirstSingView;
    private YYTextView mSecondSingView;
    private MicUpPanelCircleView mFunctionView;
    private SVGAImageView mRecognizingView;
    private static final int TOTAL_WAIT_TIME = 20000;
    private static final int ANIMATION_INTERVAL = 100;
    private static final int SINGING_TIME = 6000;
    private BubblePopupWindow mPopWindow;
    private YYTextView mBubbleTextView;
    protected boolean mCurrViewDetached = false;

    public MicUpSingView(Context context, MicUpUICallback uiCallback) {
        this(context, null, uiCallback);
    }

    public MicUpSingView(Context context, AttributeSet attrs, MicUpUICallback uiCallback) {
        this(context, attrs, 0, uiCallback);
    }

    public MicUpSingView(Context context, AttributeSet attrs, int defStyleAttr, MicUpUICallback uiCallback) {
        super(context, attrs, defStyleAttr);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.setBackgroundResource(R.drawable.bg_mic_up_incomplete_panel);
        this.mUICallback = uiCallback;
        this.createView(context);
        this.initPopWindow();
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_mic_up_sing_channel, (ViewGroup)this);
        this.mFirstLeadSingView = (YYTextView)this.findViewById(R.id.tv_first_lead_lyric);
        this.mSecondLeadSingView = (YYTextView)this.findViewById(R.id.tv_second_lead_lyric);
        this.mMicUpHeartView = (MicUpHeartView)this.findViewById(R.id.view_life_container);
        RecycleImageView rulesView = (RecycleImageView)this.findViewById(R.id.iv_rules);
        this.mFirstSingView = (YYTextView)this.findViewById(R.id.tv_first_lyric);
        this.mSecondSingView = (YYTextView)this.findViewById(R.id.tv_second_lyric);
        this.mFunctionView = (MicUpPanelCircleView)this.findViewById(R.id.iv_function);
        this.mFunctionView.updateBackground(R.drawable.icon_mic_up_done);
        this.mRecognizingView = (SVGAImageView)this.findViewById(R.id.svga_recognizing);
        rulesView.setOnClickListener((View.OnClickListener)this);
        this.mFunctionView.setOnClickListener(this);
    }

    @UiThread
    public void updateSongInfo(@NonNull List<String> preLyrics, @NonNull List<String> postLyrics) {
        int i;
        int size;
        if (!FP.empty(preLyrics)) {
            size = preLyrics.size();
            for (i = 0; i < size; ++i) {
                if (i == 0) {
                    String firstLeadLyric = preLyrics.get(0);
                    this.mFirstLeadSingView.setText((CharSequence)firstLeadLyric);
                    continue;
                }
                if (i != 1) break;
                String secondLeadLyric = preLyrics.get(1);
                this.mSecondLeadSingView.setText((CharSequence)secondLeadLyric);
            }
        }
        if (!FP.empty(postLyrics)) {
            size = postLyrics.size();
            for (i = 0; i < size; ++i) {
                if (i == 0) {
                    String firstSingLyric = postLyrics.get(0);
                    this.mFirstSingView.setText((CharSequence)firstSingLyric);
                    continue;
                }
                if (i != 1) break;
                String secondSingLyric = postLyrics.get(1);
                this.mSecondSingView.setText((CharSequence)secondSingLyric);
            }
        }
        if (this.mRecognizingView != null && this.mRecognizingView.getVisibility() == 0) {
            this.mRecognizingView.setVisibility(8);
        }
        if (this.mFunctionView != null && this.mFunctionView.getVisibility() != 0) {
            this.mFunctionView.setVisibility(0);
        }
        this.startTimer();
    }

    @UiThread
    public void updateLeftLifeValue(int leftLifeValue) {
        if (this.mMicUpHeartView != null) {
            this.mMicUpHeartView.setLeftLifeValue(leftLifeValue);
        } else {
            FeatureLog.e((String)"FTMicUpPanel", (String)"updateLeftLifeValue mMicUpHeartView == null.", (Object[])new Object[0]);
        }
    }

    @UiThread
    public void updateRecognizingBackground() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
        if (this.mFunctionView != null) {
            this.mFunctionView.setVisibility(8);
        }
        if (this.mRecognizingView != null) {
            this.mRecognizingView.setVisibility(0);
            DyResLoader.INSTANCE.loadSvga(this.mRecognizingView, DR.mic_up_recognizing_btn, true);
        }
    }

    private void startTimer() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
        this.mCountDownTimer = new CountDownTimer(20050L, 100L){

            public void onTick(long millisUntilFinished) {
                if (MicUpSingView.this.mFunctionView != null && MicUpSingView.this.mFunctionView.getVisibility() == 0) {
                    int progress = (int)(20000L - millisUntilFinished + 1L);
                    MicUpSingView.this.mFunctionView.updateProgress(progress, 20000);
                    if (progress > 6000) {
                        MicUpSingView.this.showSubmitTip();
                    }
                }
            }

            public void onFinish() {
                if (MicUpSingView.this.mUICallback != null) {
                    MicUpSingView.this.mUICallback.onSubmitAudioClick();
                }
            }
        }.start();
    }

    private void showSubmitTip() {
        if (this.mPopWindow != null && this.mPopWindow.isShowing()) {
            return;
        }
        boolean needShowSubmitTip = SettingFlags.getBoolean((String)"key_mic_up_submit_tip", (boolean)true);
        if (needShowSubmitTip) {
            this.showHorizontalPopWindow((View)this.mFunctionView, R.string.tips_mic_up_tap_finish);
            SettingFlags.setBoolean((String)"key_mic_up_submit_tip", (boolean)false);
        }
    }

    public void onClick(View view) {
        if (view == null) {
            return;
        }
        int viewId = view.getId();
        if (viewId == R.id.iv_rules) {
            if (this.mUICallback != null) {
                this.mUICallback.onGameRuleClick();
            }
        } else if (viewId == R.id.iv_function) {
            int progress;
            if (this.mFunctionView != null && (progress = this.mFunctionView.getProgress()) <= 6000) {
                ToastUtils.showToast((Context)this.getContext(), (int)R.string.short_tips_sing_longer);
                return;
            }
            if (this.mUICallback != null) {
                this.mUICallback.onSubmitAudioClick();
            }
            if (this.mCountDownTimer != null) {
                this.mCountDownTimer.cancel();
            }
        }
    }

    private void initPopWindow() {
        View contentView = View.inflate((Context)this.getContext(), (int)R.layout.view_mic_up_pop_channel, null);
        this.mBubbleTextView = (YYTextView)contentView.findViewById(R.id.tv_tip);
        BubbleStyle bubbleStyle = (BubbleStyle)contentView.findViewById(R.id.pop_container);
        bubbleStyle.setFillColor(ColorUtils.parseColor((String)"#FF25D572"));
        bubbleStyle.setCornerRadius((float)ResolutionUtils.dip2Px((float)5.0f));
        this.mPopWindow = new BubblePopupWindow(contentView, bubbleStyle);
        this.mPopWindow.setCancelOnTouch(false);
        this.mPopWindow.setCancelOnTouchOutside(false);
    }

    private void showHorizontalPopWindow(@NonNull View targetView, @StringRes int stringRes) {
        if (this.mCurrViewDetached) {
            return;
        }
        this.mBubbleTextView.setText((CharSequence)ResourceUtils.getString((int)stringRes));
        this.mPopWindow.showArrowTo(targetView, BubbleStyle.ArrowDirection.Right);
    }

    @Override
    public void onDestroy() {
        if (this.mRecognizingView != null && this.mRecognizingView.isAnimating()) {
            this.mRecognizingView.stopAnimation();
        }
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mCurrViewDetached = false;
    }

    protected void onDetachedFromWindow() {
        this.mCurrViewDetached = true;
        if (this.mPopWindow != null) {
            this.mPopWindow.dismiss();
        }
        super.onDetachedFromWindow();
    }
}

