/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel.flyingscreen;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpView;

public class MicUpGetChanceView
extends YYConstraintLayout
implements IMicUpView {
    private CircleImageView mAvatarView;
    private YYTextView mMyNameView;
    private YYTextView mOtherNameView;

    public MicUpGetChanceView(Context context) {
        this(context, null);
    }

    public MicUpGetChanceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MicUpGetChanceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.createView(context);
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.view_mic_up_get_chance_channel, (ViewGroup)this);
        this.mAvatarView = (CircleImageView)this.findViewById(R.id.iv_avatar);
        this.mMyNameView = (YYTextView)this.findViewById(R.id.tv_my_name);
        this.mOtherNameView = (YYTextView)this.findViewById(R.id.tv_other_name);
    }

    @UiThread
    public void updateUI(@NonNull String avatar, boolean isMe, @Nullable String nick) {
        if (this.mAvatarView != null) {
            ImageLoader.loadImage((ImageView)this.mAvatarView, (String)avatar, (int)R.drawable.icon_avatar_default_male, (int)R.drawable.icon_avatar_default_male);
        }
        if (this.mMyNameView != null && this.mOtherNameView != null) {
            if (isMe) {
                this.mMyNameView.setVisibility(0);
                this.mOtherNameView.setVisibility(8);
            } else {
                this.mMyNameView.setVisibility(8);
                this.mOtherNameView.setVisibility(0);
                this.mOtherNameView.setText((CharSequence)nick);
            }
        }
    }

    @Override
    public void onDestroy() {
    }
}

