/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.panel;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.SimpleAnimatorListener;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.plugins.micup.bean.LeadSingDataInfo;
import com.yy.hiyo.channel.plugins.micup.bean.SongInfo;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpView;
import com.yy.hiyo.channel.plugins.micup.panel.IMicUpPanelView;
import com.yy.hiyo.channel.plugins.micup.panel.MicUpUICallback;
import com.yy.hiyo.channel.plugins.micup.panel.countdown.ICountDownCallback;
import com.yy.hiyo.channel.plugins.micup.panel.countdown.MicUpCountDownView;
import com.yy.hiyo.channel.plugins.micup.panel.determine.MicUpAudienceDetermineView;
import com.yy.hiyo.channel.plugins.micup.panel.determine.MicUpDetermineView;
import com.yy.hiyo.channel.plugins.micup.panel.flyingscreen.MicUpGetChanceView;
import com.yy.hiyo.channel.plugins.micup.panel.flyingscreen.MicUpNextSongView;
import com.yy.hiyo.channel.plugins.micup.panel.flyingscreen.MicUpNoChanceView;
import com.yy.hiyo.channel.plugins.micup.panel.leadsing.MicUpAudienceLeadSingView;
import com.yy.hiyo.channel.plugins.micup.panel.leadsing.MicUpLeadSingView;
import com.yy.hiyo.channel.plugins.micup.panel.sing.MicUpAudienceSingView;
import com.yy.hiyo.channel.plugins.micup.panel.sing.MicUpSingView;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class MicUpPanelView
extends YYFrameLayout
implements IMicUpPanelView,
IMicUpView {
    private MicUpUICallback mUICallback;
    private MicUpCountDownView mCountDownView;
    private MicUpLeadSingView mLeadSingView;
    private MicUpAudienceLeadSingView mAudienceLeadSingView;
    private MicUpSingView mSingView;
    private MicUpAudienceSingView mAudienceSingView;
    private MicUpGetChanceView mGetChanceView;
    private MicUpNextSongView mNextSongView;
    private MicUpNoChanceView mNoChanceView;
    private MicUpDetermineView mDetermineView;
    private MicUpAudienceDetermineView mAudienceDetermineView;
    private static final FrameLayout.LayoutParams VIEW_LAYOUT_PARAMS = new FrameLayout.LayoutParams(-1, -1, 17);
    private static final int PADDING = ResolutionUtils.dip2Px((float)10.0f);

    public MicUpPanelView(Context context, MicUpUICallback uiCallback) {
        this(context, null, uiCallback);
    }

    public MicUpPanelView(Context context, AttributeSet attrs, MicUpUICallback uiCallback) {
        this(context, attrs, 0, uiCallback);
    }

    public MicUpPanelView(Context context, AttributeSet attrs, int defStyle, MicUpUICallback uiCallback) {
        super(context, attrs, defStyle);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.mUICallback = uiCallback;
        this.createView(context);
    }

    private void createView(Context context) {
        this.mCountDownView = new MicUpCountDownView(context);
        this.mLeadSingView = new MicUpLeadSingView(context, this.mUICallback);
        this.mAudienceLeadSingView = new MicUpAudienceLeadSingView(context);
        this.mAudienceLeadSingView.setUICallback(this.mUICallback);
        this.mGetChanceView = new MicUpGetChanceView(context);
        this.mNextSongView = new MicUpNextSongView(context);
        this.mNoChanceView = new MicUpNoChanceView(context);
        this.mSingView = new MicUpSingView(context, this.mUICallback);
        this.mAudienceSingView = new MicUpAudienceSingView(context);
        this.mAudienceSingView.setUICallback(this.mUICallback);
        this.mDetermineView = new MicUpDetermineView(context);
        this.mDetermineView.setUICallback(this.mUICallback);
        this.mAudienceDetermineView = new MicUpAudienceDetermineView(context);
        this.mAudienceDetermineView.setUICallback(this.mUICallback);
    }

    @Override
    public void showCountDownPanel(ICountDownCallback countDownCallback) {
        this.removeAllViews();
        this.addView((View)this.mCountDownView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mCountDownView.startCountDown(countDownCallback);
    }

    @Override
    public void showLeadSingPanel(LeadSingDataInfo leadSingDataInfo) {
        this.removeAllViews();
        this.addView((View)this.mLeadSingView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mLeadSingView.updateSongInfo(leadSingDataInfo.currentSongInfo);
        this.mLeadSingView.updateLeftLifeValue(leadSingDataInfo.leftLifeValue);
        this.mLeadSingView.setMaxRound(leadSingDataInfo.totalSong);
        this.mLeadSingView.setCurrentRound(leadSingDataInfo.currentRound);
    }

    @Override
    public void showAudienceLeadSingPanel(SongInfo songInfo, int currentRound, int totalRound) {
        this.removeAllViews();
        this.addView((View)this.mAudienceLeadSingView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mAudienceLeadSingView.updateSongInfo(songInfo);
        this.mAudienceLeadSingView.setMaxRound(totalRound);
        this.mAudienceLeadSingView.setCurrentRound(currentRound);
    }

    @Override
    public void showSingPanel(List<String> preLyrics, List<String> postLyrics, int leftLifeValue) {
        this.removeAllViews();
        this.addView((View)this.mSingView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mSingView.updateSongInfo(preLyrics, postLyrics);
        this.mSingView.updateLeftLifeValue(leftLifeValue);
    }

    @Override
    public void showAudienceSingPanel(@NonNull String avatar, long singerUid) {
        this.removeAllViews();
        this.addView((View)this.mAudienceSingView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mAudienceSingView.startPlaySvga(0, avatar);
        this.mAudienceSingView.setUid(singerUid);
    }

    @Override
    public void showMyTurnPanel(@NonNull String avatar, @NonNull String nick) {
        this.removeAllViews();
        this.addView((View)this.mGetChanceView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mGetChanceView.updateUI(avatar, true, nick);
        this.startEnterAnimation((View)this.mGetChanceView, 0);
    }

    @Override
    public void showOtherTurnPanel(@NonNull String avatar, @NonNull String nick) {
        this.removeAllViews();
        this.addView((View)this.mGetChanceView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mGetChanceView.updateUI(avatar, false, nick);
        this.startEnterAnimation((View)this.mGetChanceView, 1);
    }

    @Override
    public void showAllFailedPanel() {
        this.removeAllViews();
        this.addView((View)this.mNoChanceView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.startEnterAnimation((View)this.mNoChanceView, 2);
    }

    @Override
    public void showNextSongPanel(int curr, int total) {
        this.removeAllViews();
        this.addView((View)this.mNextSongView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mNextSongView.setSongProgress(curr, total);
        this.startEnterAnimation((View)this.mNextSongView, 3);
    }

    @Override
    public void showRecognizingPanel() {
        if (this.mSingView != null) {
            this.mSingView.updateRecognizingBackground();
        }
    }

    @Override
    public void showDeterminePanel(int singStatus, @NonNull String avatar, int leftLife) {
        this.removeAllViews();
        this.addView((View)this.mDetermineView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mDetermineView.setUid(AccountUtil.getUid());
        this.mDetermineView.startPlaySvga(singStatus, avatar);
        this.mDetermineView.updateUI(leftLife);
    }

    @Override
    public void showAudienceDeterminePanel(long singerUid, int singStatus, @NonNull String avatar) {
        this.removeAllViews();
        this.addView((View)this.mAudienceDetermineView, (ViewGroup.LayoutParams)VIEW_LAYOUT_PARAMS);
        this.mAudienceDetermineView.setUid(singerUid);
        this.mAudienceDetermineView.startPlaySvga(singStatus, avatar);
    }

    @Override
    public void enableClickGet() {
        if (this.mLeadSingView != null) {
            this.mLeadSingView.enableClickGet();
        }
    }

    private void startEnterAnimation(@NonNull View targetView, final int type) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)targetView, (String)"translationX", (float[])new float[]{-400.0f, 0.0f});
        animator.setDuration(400L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            public void onAnimationEnd(Animator animation) {
                MicUpPanelView.this.postDelayed(() -> {
                    switch (type) {
                        case 0: {
                            if (MicUpPanelView.this.mUICallback == null) break;
                            MicUpPanelView.this.mUICallback.onShowMyTurnEnd();
                            break;
                        }
                        case 1: {
                            if (MicUpPanelView.this.mUICallback == null) break;
                            MicUpPanelView.this.mUICallback.onShowOtherTurnEnd();
                            break;
                        }
                        case 2: {
                            if (MicUpPanelView.this.mUICallback == null) break;
                            MicUpPanelView.this.mUICallback.onShowAllFailedEnd();
                            break;
                        }
                        case 3: {
                            if (MicUpPanelView.this.mUICallback == null) break;
                            MicUpPanelView.this.mUICallback.onShowNextEnd();
                            break;
                        }
                    }
                }, 3000L);
            }
        });
        animator.start();
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof MicUpLeadSingView || child instanceof MicUpAudienceLeadSingView || child instanceof MicUpSingView || child instanceof MicUpAudienceSingView) {
            this.setPadding(PADDING, 0, PADDING, 0);
        } else {
            this.setPadding(0, 0, 0, 0);
        }
        super.addView(child, index, params);
    }

    public void removeAllViews() {
        this.stopCountDown();
        this.onDestroyView((ViewGroup)this);
        super.removeAllViews();
    }

    private void stopCountDown() {
        if (this.mCountDownView != null && this.mCountDownView.isAttachToWindow()) {
            this.mCountDownView.stopCountDown();
        }
    }

    @Override
    public void onDestroy() {
    }

    private void onDestroyView(ViewGroup viewGroup) {
        if (viewGroup instanceof IMicUpView) {
            ((IMicUpView)viewGroup).onDestroy();
        }
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof ViewGroup) {
                this.onDestroyView((ViewGroup)view);
                continue;
            }
            if (!(view instanceof IMicUpView)) continue;
            ((IMicUpView)view).onDestroy();
        }
    }
}

