/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.impl;

import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.DataFetchCallback;
import com.yy.base.utils.FP;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.channel.plugins.micup.MicUpStatisHelper;
import com.yy.hiyo.channel.plugins.micup.interfaces.ISongRepoManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.SongRepoSwitchListener;
import com.yy.hiyo.channel.plugins.micup.songrepo.OnSongRepoSelectListener;
import com.yy.hiyo.channel.plugins.micup.songrepo.SongRepoDataProvider;
import com.yy.hiyo.channel.plugins.micup.songrepo.SongRepoInfo;
import com.yy.hiyo.channel.plugins.micup.songrepo.SongRepoPanel;
import com.yy.hiyo.channel.plugins.micup.songrepo.SongRepoTag;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import common.Header;
import net.ihago.room.srv.micup.ChooseSongLibReq;
import net.ihago.room.srv.micup.ChooseSongLibRes;
import net.ihago.room.srv.micup.ChooseSongLibTypeNotify;
import net.ihago.room.srv.micup.MicUPNotify;
import net.ihago.room.srv.micup.SongLibTypeInfo;
import net.ihago.room.srv.micup.Uri;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SongRepoManager
implements ISongRepoManager {
    private String mChannelId;
    private SongRepoInfo mCurrSongRepo;
    private SongRepoSwitchListener mSongRepoSwitchListener;
    private SongRepoDataProvider mDataProvider = new SongRepoDataProvider();
    private IProtoNotify<MicUPNotify> mProtoNotify = new IProtoNotify<MicUPNotify>(){

        public String serviceName() {
            return "net.ihago.room.srv.micup";
        }

        public void onNotify(@NonNull MicUPNotify notify) {
            String roomId;
            if (FP.empty((CharSequence)SongRepoManager.this.mChannelId)) {
                return;
            }
            Header header = notify.header;
            String string2 = roomId = header != null ? header.roomid : "";
            if (!roomId.equals(SongRepoManager.this.mChannelId)) {
                return;
            }
            if (notify.uri == Uri.kUriChooseSongLib) {
                SongRepoManager.this.onSongRepoChangedNotify(notify.choose_song_lib_type);
            }
        }
    };

    public SongRepoManager(String channelId) {
        this.mChannelId = channelId;
    }

    @Override
    @androidx.annotation.Nullable
    public SongRepoInfo getCurrSongRepo() {
        return this.mCurrSongRepo;
    }

    @Override
    public void setCurrSongRepo(SongRepoInfo currSongRepo) {
        this.mCurrSongRepo = currSongRepo;
    }

    @Override
    public void requestSwitchSongRepo(SongRepoInfo songRepo, final DataFetchCallback<Boolean> callback) {
        if (songRepo == null) {
            return;
        }
        if (this.mCurrSongRepo != null && this.mCurrSongRepo.getId() == songRepo.getId()) {
            return;
        }
        if (FP.empty((CharSequence)this.mChannelId)) {
            return;
        }
        ChooseSongLibReq req = new ChooseSongLibReq.Builder().song_lib_type(Long.valueOf(songRepo.getId())).build();
        ProtoManager.getInstance().sendHttp(this.mChannelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<ChooseSongLibRes>(){

            public void onError(String reason, int code) {
                super.onError(reason, code);
                if (callback != null) {
                    callback.onFailure((long)code, reason);
                }
            }

            public void onResponse(@NonNull ChooseSongLibRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (callback != null) {
                    if (this.isSuccess(code)) {
                        callback.onSuccess((Object)true);
                    } else {
                        callback.onFailure(code, msg);
                    }
                }
            }
        });
    }

    @Override
    public void requestCurrSongRepo(final DataFetchCallback<SongRepoInfo> callback) {
        if (FP.empty((CharSequence)this.mChannelId)) {
            return;
        }
        this.mDataProvider.fetchRoomCurrSongRepo(this.mChannelId, new DataFetchCallback<SongRepoInfo>(){

            public void onSuccess(@Nullable SongRepoInfo data) {
                SongRepoManager.this.mCurrSongRepo = data;
                if (callback != null) {
                    callback.onSuccess((Object)data);
                }
            }

            public void onFailure(long code, @NotNull String msg) {
                if (callback != null) {
                    callback.onFailure(code, msg);
                }
            }
        });
    }

    @Override
    public void setSongRepoSwitchListener(SongRepoSwitchListener listener) {
        this.mSongRepoSwitchListener = listener;
    }

    @Override
    public void init() {
        ProtoManager.getInstance().registerNotify(this.mProtoNotify);
    }

    @Override
    public void destroy() {
        ProtoManager.getInstance().unregisterNotify(this.mProtoNotify);
        this.mCurrSongRepo = null;
    }

    private void onSongRepoChangedNotify(ChooseSongLibTypeNotify notify) {
        SongLibTypeInfo notifyInfo;
        if (this.mSongRepoSwitchListener != null && (notifyInfo = notify.info) != null) {
            SongRepoInfo songRepo;
            this.mCurrSongRepo = songRepo = new SongRepoInfo(notifyInfo.id, notifyInfo.name, SongRepoTag.NONE);
            this.mSongRepoSwitchListener.onSongRepoSwitch(songRepo);
        }
    }

    @Override
    public void showSongRepoSelectPanel(DefaultWindow window, OnSongRepoSelectListener listener) {
        if (window == null) {
            return;
        }
        SongRepoPanel panel = new SongRepoPanel(window.getContext(), this.mDataProvider);
        panel.setSongRepoSelectListener(songRepo -> {
            window.getPanelLayer().hidePanel((BasePanel)panel, true);
            if (listener != null) {
                listener.onSongRepoSelect(songRepo);
            }
            if (!FP.empty((CharSequence)this.mChannelId)) {
                MicUpStatisHelper.reportMuSetPgMuButClick(this.mChannelId, songRepo.getId());
            }
        });
        panel.setOutsideClickListener(() -> {
            window.getPanelLayer().hidePanel((BasePanel)panel, true);
            if (!FP.empty((CharSequence)this.mChannelId)) {
                MicUpStatisHelper.reportMuSetPgCloseClick(this.mChannelId);
            }
        });
        window.getPanelLayer().showPanel((BasePanel)panel, true);
    }
}

