/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.impl;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.collection.LongSparseArray;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.SeatUserAdapter;
import com.yy.hiyo.channel.plugins.micup.VH;
import com.yy.hiyo.channel.plugins.micup.base.BaseComponent;
import com.yy.hiyo.channel.plugins.micup.bean.MicupDataContext;
import com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.micup.bean.RoundInfo;
import com.yy.hiyo.channel.plugins.micup.bean.SeatUser;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupDataChangeNotify;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupHost;
import com.yy.hiyo.channel.plugins.micup.interfaces.ISeatManager;
import com.yy.hiyo.mvp.base.IMvpContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SeatManager
extends BaseComponent
implements ISeatManager,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = "FTMicUpSeatManager";
    private final LongSparseArray<SeatUser> seatUsers = new LongSparseArray();
    private RecyclerView rvSeatUsers;
    private SeatUserAdapter seatUserAdapter;
    private OnSeatActionListener mSeatActionListener;
    private IMicupDataChangeNotify notify = new IMicupDataChangeNotify(){

        @Override
        public void onNextRoundNotify(int round) {
            SeatManager.this.resetStateExceptOut();
        }

        @Override
        public void onUserGetTheChanceNotify(long uid, int round, String avatar, String nick) {
            SeatManager.this.resetStateExceptOut();
            SeatManager.this.updateUserState(uid, 1);
        }

        @Override
        public void onSongIdentifyResultNotify(RoundInfo roundInfo) {
            SeatManager.this.resetStateExceptOut();
            if (roundInfo.getSongIdentifyState() == 2) {
                SeatManager.this.updateUserState(roundInfo.getUid(), 2);
            } else if (roundInfo.getSongIdentifyState() == 3) {
                long uid = roundInfo.getUid();
                PlayerInfo playerInfo = SeatManager.this.getDataContext().getPlayer(uid);
                if (playerInfo != null && playerInfo.getLife() <= 0) {
                    SeatManager.this.updateUserState(roundInfo.getUid(), 4);
                } else {
                    SeatManager.this.updateUserState(roundInfo.getUid(), 3);
                }
            }
            this.updateTopOneUser();
        }

        private void updateTopOneUser() {
            SeatUser previousTopestUser = null;
            SeatUser currentTopestUser = null;
            for (int i = 0; i < SeatManager.this.seatUsers.size(); ++i) {
                SeatUser seatUser = (SeatUser)((Object)SeatManager.this.seatUsers.valueAt(i));
                if (seatUser.isFirst()) {
                    previousTopestUser = seatUser;
                    continue;
                }
                if (seatUser.playerInfo.getScore() <= 0) continue;
                if (currentTopestUser == null) {
                    currentTopestUser = seatUser;
                    continue;
                }
                if (seatUser.playerInfo.getScore() <= currentTopestUser.playerInfo.getScore()) continue;
                currentTopestUser = seatUser;
            }
            if (previousTopestUser == null && currentTopestUser != null) {
                currentTopestUser.setFirst(true);
            } else if (previousTopestUser != null && currentTopestUser != null && currentTopestUser.playerInfo.getScore() > previousTopestUser.playerInfo.getScore()) {
                previousTopestUser.setFirst(false);
                currentTopestUser.setFirst(true);
            }
        }

        @Override
        public void onUpdateRoundInfoNotify(List<PlayerInfo> playerInfos, int errorCode, String errMsg) {
            SeatManager.this.updateSeatUsers(SeatManager.this.getDataContext().getPlayerList());
        }

        @Override
        public void onWaitForDetermineNotify(int round, int term) {
            SeatManager.this.resetStateExceptOut();
        }
    };
    private MyOnGlobalLayoutListener layoutListener = new MyOnGlobalLayoutListener(this);

    public void onGlobalLayout() {
        this.updateSeatPositions();
    }

    public SeatManager(RoomData roomDataContainer, MicupDataContext dataContext) {
        super(roomDataContainer, dataContext);
    }

    @Override
    public void setViewContainer(YYFrameLayout viewGroup) {
        this.rvSeatUsers = (RecyclerView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_micup_seat_channel, (ViewGroup)viewGroup).findViewById(R.id.rv_seat);
        this.rvSeatUsers.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getContext(), 0, false));
        this.seatUserAdapter = new SeatUserAdapter();
        this.rvSeatUsers.setAdapter((RecyclerView.Adapter)this.seatUserAdapter);
        this.setSeatActionListener(this.mSeatActionListener);
        if (this.getDataContext().getPlayerList() != null) {
            this.updateSeatUsers(this.getDataContext().getPlayerList());
        }
    }

    @Override
    public void setSeatActionListener(OnSeatActionListener listener) {
        this.mSeatActionListener = listener;
        if (this.seatUserAdapter != null) {
            this.seatUserAdapter.setSeatActionListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSeatUsers(List<PlayerInfo> playInfoList) {
        if (playInfoList == null || playInfoList.isEmpty()) {
            MLog.error((Object)TAG, (String)"seat user empty!!!", (Object[])new Object[0]);
            return;
        }
        ArrayList<PlayerInfo> copyList = new ArrayList<PlayerInfo>(playInfoList);
        long topUid = copyList.get(0).getUid();
        Collections.sort(copyList, new Comparator<PlayerInfo>(){

            @Override
            public int compare(PlayerInfo o1, PlayerInfo o2) {
                int index1 = o1.getIndex();
                int index2 = o2.getIndex();
                return Integer.compare(index1, index2);
            }
        });
        ArrayList<SeatUser> copyUserList = new ArrayList<SeatUser>();
        ArrayList<Long> uids = new ArrayList<Long>();
        SeatUser topestUser = null;
        int i = 0;
        for (PlayerInfo playerInfo : copyList) {
            if (playerInfo != null && playerInfo.getUid() > 0L) {
                SeatUser seatUser;
                long uid = playerInfo.getUid();
                LongSparseArray<SeatUser> longSparseArray = this.seatUsers;
                synchronized (longSparseArray) {
                    seatUser = (SeatUser)((Object)this.seatUsers.get(uid));
                    if (seatUser == null) {
                        seatUser = new SeatUser(playerInfo);
                        seatUser.setIndex(i);
                        seatUser.userInfoKS = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid);
                        this.seatUsers.put(uid, (Object)seatUser);
                        uids.add(uid);
                    }
                }
                ++i;
                if (playerInfo.getLife() == 0) {
                    seatUser.setState(4);
                }
                if (topUid == uid && seatUser.playerInfo.getScore() > 0) {
                    topestUser = seatUser;
                    topestUser.setFirst(true);
                } else {
                    seatUser.setFirst(false);
                }
                copyUserList.add(seatUser);
                continue;
            }
            MLog.error((Object)TAG, (String)"error input!!!play info null or uid error", (Object[])new Object[0]);
        }
        if (!uids.isEmpty()) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, null);
        }
        if (this.seatUserAdapter != null) {
            this.seatUserAdapter.setmSeatUsers(copyUserList);
        }
        if (this.rvSeatUsers == null) {
            return;
        }
        this.removeLayoutListener();
        this.rvSeatUsers.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.layoutListener);
        this.rvSeatUsers.post(new Runnable(){

            @Override
            public void run() {
                SeatManager.this.updateSeatPositions();
            }
        });
    }

    private void updateSeatPositions() {
        if (this.rvSeatUsers != null) {
            RecyclerView.LayoutManager manager = this.rvSeatUsers.getLayoutManager();
            HashMap<Long, Point> loctionMap = new HashMap<Long, Point>();
            int size = manager.getChildCount();
            for (int i = 0; i < size; ++i) {
                int[] loction = new int[2];
                View child = manager.getChildAt(i);
                RecyclerView.ViewHolder holder = this.rvSeatUsers.getChildViewHolder(child);
                if (!(holder instanceof VH)) continue;
                RecycleImageView avator = ((VH)holder).getIvAvatar();
                avator.getLocationOnScreen(loction);
                int width = avator.getWidth();
                int hight = avator.getHeight();
                ScreenWrapperUtils.INSTANCE.paraseLocationInWindow(loction);
                loction[0] = loction[0] + width / 2;
                loction[1] = loction[1] + hight / 2;
                loctionMap.put(((VH)holder).getSeatUser().playerInfo.getUid(), new Point(loction[0], loction[1]));
            }
            if (!loctionMap.isEmpty() && this.host != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("seat", loctionMap);
                this.host.onHandleEvent(2, map);
            }
        }
    }

    @Override
    public void updateUserState(long uid, int state) {
        SeatUser seatUser = (SeatUser)((Object)this.seatUsers.get(uid));
        if (seatUser != null) {
            seatUser.setState(state);
        } else {
            MLog.error((Object)TAG, (String)"user not in list !!! uid:%d", (Object[])new Object[]{uid});
        }
    }

    @Override
    public void resetStateExceptOut() {
        for (int i = 0; i < this.seatUsers.size(); ++i) {
            SeatUser seatUser = (SeatUser)((Object)this.seatUsers.valueAt(i));
            if (seatUser == null || seatUser.getState() == 4) continue;
            seatUser.setState(0);
        }
    }

    @Override
    public boolean hasSitDown(long uid) {
        return this.seatUsers.get(uid) != null;
    }

    @Override
    public void onCreate(IMicupHost host, IMvpContext context) {
        super.onCreate(host, context);
        MLog.info((Object)TAG, (String)"oncreate", (Object[])new Object[0]);
        host.registerDataNotify(this.notify);
    }

    @Override
    public void onDestroy(int reasonCode) {
        super.onDestroy(reasonCode);
        if (reasonCode == 0) {
            this.seatUsers.clear();
            if (this.host != null) {
                this.host.unRegisterDataNotify(this.notify);
            }
        }
        if (this.seatUserAdapter != null) {
            this.seatUserAdapter.destroy();
            this.seatUserAdapter = null;
        }
        this.removeLayoutListener();
        this.layoutListener = null;
        this.rvSeatUsers = null;
    }

    private void removeLayoutListener() {
        if (this.rvSeatUsers != null && this.rvSeatUsers.getViewTreeObserver() != null && this.layoutListener != null) {
            if (Build.VERSION.SDK_INT < 16) {
                this.rvSeatUsers.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.layoutListener);
            } else {
                this.rvSeatUsers.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.layoutListener);
            }
        }
    }

    public static interface OnSeatActionListener {
        public void onAvatarClick(SeatUser var1);
    }

    private static class MyOnGlobalLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<ViewTreeObserver.OnGlobalLayoutListener> callback;

        public MyOnGlobalLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
            this.callback = new WeakReference<ViewTreeObserver.OnGlobalLayoutListener>(listener);
        }

        public void onGlobalLayout() {
            ViewTreeObserver.OnGlobalLayoutListener real;
            if (this.callback != null && (real = (ViewTreeObserver.OnGlobalLayoutListener)this.callback.get()) != null) {
                real.onGlobalLayout();
            }
        }
    }
}

