/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;

public class MicUpResultItemView
extends YYConstraintLayout {
    private YYTextView mRankView;
    private RecycleImageView mCrownView;
    private CircleImageView mAvatarView;
    private YYTextView mNickView;
    private YYTextView mMicNumView;
    private YYTextView mScoreView;
    private View mDividerView;

    public MicUpResultItemView(Context context) {
        super(context);
        this.createView(context);
    }

    public MicUpResultItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public MicUpResultItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.createView(context);
    }

    private void createView(Context context) {
        View itemView = LayoutInflater.from((Context)context).inflate(R.layout.item_mic_up_result_rank_channel, (ViewGroup)this);
        this.mRankView = (YYTextView)itemView.findViewById(R.id.tv_rank);
        this.mCrownView = (RecycleImageView)itemView.findViewById(R.id.iv_crown);
        this.mAvatarView = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
        this.mNickView = (YYTextView)itemView.findViewById(R.id.tv_user_name);
        this.mNickView.setTextColor(ResourceUtils.getColor((int)R.color.white));
        this.mMicNumView = (YYTextView)itemView.findViewById(R.id.tv_mic_num);
        this.mMicNumView.setTextColor(ResourceUtils.getColor((int)R.color.white));
        YYTextView micNumTipView = (YYTextView)itemView.findViewById(R.id.tv_mic_num_tip);
        micNumTipView.setTextColor(ResourceUtils.getColor((int)R.color.live_common_color_9_transparent_50));
        this.mScoreView = (YYTextView)itemView.findViewById(R.id.tv_score);
        this.mScoreView.setTextColor(ResourceUtils.getColor((int)R.color.white));
        YYTextView scoreTipView = (YYTextView)itemView.findViewById(R.id.tv_score_tip);
        scoreTipView.setTextColor(ResourceUtils.getColor((int)R.color.live_common_color_9_transparent_50));
        View line = itemView.findViewById(R.id.line);
        line.setBackgroundColor(ResourceUtils.getColor((int)R.color.live_common_color_9_transparent_50));
        this.mDividerView = itemView.findViewById(R.id.view_divider);
        this.mDividerView.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_1aebebeb));
    }

    @UiThread
    public void hideDividerLine() {
        if (this.mDividerView != null) {
            this.mDividerView.setVisibility(8);
        }
    }

    @UiThread
    public void renderItem(@NonNull ResultInfo resultInfo) {
        int rank = resultInfo.rank;
        this.mRankView.setText((CharSequence)String.valueOf(rank));
        if (rank == 1) {
            this.mRankView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_first));
            this.mCrownView.setVisibility(0);
            this.mCrownView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_first_crown));
        } else if (rank == 2) {
            this.mRankView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_second));
            this.mCrownView.setVisibility(0);
            this.mCrownView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_second_crown));
        } else if (rank == 3) {
            this.mRankView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_third));
            this.mCrownView.setVisibility(0);
            this.mCrownView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_third_crown));
        } else {
            this.mCrownView.setVisibility(8);
            this.mRankView.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.icon_mic_up_result_rank_normal));
        }
        ImageLoader.loadImage((RecycleImageView)this.mAvatarView, (String)resultInfo.avatar, (int)R.drawable.icon_avatar_default_male, (int)R.drawable.icon_avatar_default_male);
        this.mNickView.setText((CharSequence)resultInfo.nick);
        this.mMicNumView.setText((CharSequence)String.valueOf(resultInfo.micNum));
        this.mScoreView.setText((CharSequence)String.valueOf(resultInfo.score));
    }
}

