/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.base;

import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.plugins.micup.bean.MicupDataContext;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpComponent;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupDataChangeNotify;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupHost;
import com.yy.hiyo.mvp.base.IMvpContext;

public class BaseComponent
implements IMicUpComponent {
    private static final String TAG = "BaseComponent";
    private IServiceManager serviceManager;
    private FragmentActivity context;
    private RoomData roomDataContainer;
    private MicupDataContext dataContext;
    private DialogLinkManager dialogLinkManager;
    protected IMicupHost host;
    private IMvpContext mMvpContext;
    private int state = 0;

    public BaseComponent(RoomData roomDataContainer, MicupDataContext dataContext) {
        this.roomDataContainer = roomDataContainer;
        this.dataContext = dataContext;
    }

    @Override
    public void onCreate(IMicupHost host, IMvpContext context) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onCreate", (Object[])new Object[0]);
        }
        this.host = host;
        this.mMvpContext = context;
        this.state = 1;
        this.serviceManager = ServiceManagerProxy.getServiceManager();
        this.context = (FragmentActivity)context.getContext();
        this.dialogLinkManager = new DialogLinkManager(context.getContext());
    }

    @Override
    public void onDestroy(int reasonCode) {
        this.state = reasonCode == 1 ? 2 : 3;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onDestroy code:%d", (Object[])new Object[]{reasonCode});
        }
    }

    @Override
    public IMicupDataChangeNotify getNotify() {
        return null;
    }

    public boolean isDestroy() {
        return this.state == 3;
    }

    public FragmentActivity getContext() {
        return this.context;
    }

    public IServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public RoomData getRoomDataContainer() {
        return this.roomDataContainer;
    }

    public MicupDataContext getDataContext() {
        return this.dataContext;
    }

    public DialogLinkManager getDialogLinkManager() {
        return this.dialogLinkManager;
    }

    public IMvpContext getMvpContext() {
        return this.mMvpContext;
    }
}

