/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.result;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.bean.ResultInfo;
import com.yy.hiyo.channel.plugins.micup.result.BaseMicUpResultPage;
import com.yy.hiyo.channel.plugins.micup.result.MicUpResultAdapter;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class MicUpResultPage
extends BaseMicUpResultPage
implements View.OnClickListener {
    private CircleImageView mAvatarView;
    private YYTextView mNickView;
    private YYTextView mRankView;
    private YYTextView mMicNumView;
    private YYTextView mScoreView;
    private RecyclerView mRankRecyclerView;
    private YYTextView mPlayAgainView;
    private YYTextView mShareView;
    private RecycleImageView mCloseView;
    private MicUpResultAdapter mMicUpResultAdapter;
    private CountDownTimer mCountDownTimer;
    private static final int TOTAL_TIME = 8500;
    private static final int INTERVAL_TIME = 1000;

    public MicUpResultPage(Context context, boolean isCloseInBottom) {
        super(context);
        this.createView(context, isCloseInBottom);
        this.initAdapter();
    }

    public MicUpResultPage(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    private void createView(Context context, boolean isCloseInBottom) {
        View rootView = LayoutInflater.from((Context)context).inflate(R.layout.layout_mic_up_result_page_channel, (ViewGroup)this);
        this.mAvatarView = (CircleImageView)rootView.findViewById(R.id.iv_avatar);
        this.mNickView = (YYTextView)rootView.findViewById(R.id.tv_nick);
        this.mRankView = (YYTextView)rootView.findViewById(R.id.tv_rank);
        this.mMicNumView = (YYTextView)rootView.findViewById(R.id.tv_mic_num);
        this.mScoreView = (YYTextView)rootView.findViewById(R.id.tv_score);
        this.mRankRecyclerView = (RecyclerView)rootView.findViewById(R.id.rank_list);
        this.mPlayAgainView = (YYTextView)rootView.findViewById(R.id.tv_play_again);
        this.mPlayAgainView.setOnClickListener((View.OnClickListener)this);
        this.mShareView = (YYTextView)rootView.findViewById(R.id.tv_share);
        this.mShareView.setOnClickListener((View.OnClickListener)this);
        this.mCloseView = isCloseInBottom ? (RecycleImageView)rootView.findViewById(R.id.iv_bottom_close) : (RecycleImageView)rootView.findViewById(R.id.iv_top_close);
        this.mCloseView.setVisibility(0);
        this.mCloseView.setOnClickListener((View.OnClickListener)this);
    }

    private void initAdapter() {
        this.mMicUpResultAdapter = new MicUpResultAdapter();
        this.mRankRecyclerView.setAdapter((RecyclerView.Adapter)this.mMicUpResultAdapter);
    }

    @Override
    @UiThread
    public void renderMyResult(@NonNull ResultInfo resultInfo) {
        if (this.mAvatarView != null) {
            ImageLoader.loadImage((RecycleImageView)this.mAvatarView, (String)resultInfo.avatar, (int)R.drawable.icon_avatar_default_male, (int)R.drawable.icon_avatar_default_male);
        }
        if (this.mNickView != null) {
            this.mNickView.setText((CharSequence)resultInfo.nick);
        }
        if (this.mRankView != null) {
            this.mRankView.setText((CharSequence)String.valueOf(resultInfo.rank));
        }
        if (this.mMicNumView != null) {
            this.mMicNumView.setText((CharSequence)String.valueOf(resultInfo.micNum));
        }
        if (this.mScoreView != null) {
            this.mScoreView.setText((CharSequence)String.valueOf(resultInfo.score));
        }
    }

    @Override
    @UiThread
    public void renderRankList(@NonNull List<ResultInfo> resultInfoList) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpResult", (String)"render rank list: %s", (Object[])new Object[]{resultInfoList});
        }
        if (FP.empty(resultInfoList)) {
            return;
        }
        if (this.mMicUpResultAdapter != null) {
            this.mMicUpResultAdapter.setData(resultInfoList);
        }
        this.startCountDownTimer();
    }

    private void startCountDownTimer() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
        this.mCountDownTimer = new CountDownTimer(8500L, 1000L){

            public void onTick(long millisUntilFinished) {
                if (MicUpResultPage.this.mPlayAgainView != null) {
                    String text = ResourceUtils.getString((int)R.string.play_again) + " " + millisUntilFinished / 1000L + "s";
                    MicUpResultPage.this.mPlayAgainView.setText((CharSequence)text);
                }
            }

            public void onFinish() {
                if (MicUpResultPage.this.mViewCallback != null) {
                    MicUpResultPage.this.mViewCallback.onPlayAgainTimerFinish();
                }
            }
        }.start();
    }

    public void onClick(View view) {
        if (view == null) {
            return;
        }
        int viewId = view.getId();
        if (viewId == R.id.tv_play_again) {
            if (this.mViewCallback != null) {
                this.mViewCallback.onPlayAgainClick();
            }
        } else if (viewId == R.id.tv_share) {
            if (this.mCountDownTimer != null) {
                this.mCountDownTimer.cancel();
            }
            if (this.mViewCallback != null) {
                this.mViewCallback.onShareBtnClick();
            }
            if (this.mPlayAgainView != null) {
                this.mPlayAgainView.setText((CharSequence)ResourceUtils.getString((int)R.string.play_again));
            }
        } else if (viewId == R.id.iv_bottom_close || viewId == R.id.iv_top_close) {
            if (this.mViewCallback != null) {
                this.mViewCallback.onCloseClick();
            }
        } else {
            FeatureLog.e((String)"FTMicUpResult", (String)"cannot handle this onClick: %s", (Object[])new Object[]{viewId});
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mCountDownTimer != null) {
            this.mCountDownTimer.cancel();
        }
        super.onDetachedFromWindow();
    }
}

