/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.VH;
import com.yy.hiyo.channel.plugins.micup.bean.SeatUser;
import com.yy.hiyo.channel.plugins.micup.impl.SeatManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SeatUserAdapter
extends RecyclerView.Adapter<VH> {
    private static final String TAG = "SeatUserAdapter";
    private List<SeatUser> mSeatUsers = new ArrayList<SeatUser>();
    private Set<VH> mAllViewHolder = new HashSet<VH>();
    private SeatManager.OnSeatActionListener mSeatActionListener;

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new VH(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_micup_seatuser_channel, parent, false));
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        if (holder.itemView != null) {
            holder.itemView.setOnClickListener(view -> this.handleClickEvent(position));
        }
        holder.bindData(this.mSeatUsers.get(position));
        this.mAllViewHolder.add(holder);
    }

    public int getItemCount() {
        return this.mSeatUsers.size();
    }

    public void setmSeatUsers(List<SeatUser> mSeatUsers) {
        this.mSeatUsers.clear();
        if (mSeatUsers != null && !mSeatUsers.isEmpty()) {
            this.mSeatUsers.addAll(mSeatUsers);
        }
        this.notifyDataSetChanged();
    }

    public void destroy() {
        for (VH vh : this.mAllViewHolder) {
            vh.unbindPrevious();
        }
    }

    private void handleClickEvent(int position) {
        if (FP.empty(this.mSeatUsers)) {
            return;
        }
        SeatUser seatUser = this.mSeatUsers.get(position);
        if (seatUser == null || seatUser.userInfoKS == null) {
            return;
        }
        if (this.mSeatActionListener != null) {
            this.mSeatActionListener.onAvatarClick(seatUser);
        }
    }

    public void setSeatActionListener(SeatManager.OnSeatActionListener seatActionListener) {
        this.mSeatActionListener = seatActionListener;
    }
}

