/*
 * Decompiled with CFR 0.152.
 */
package com.yy.location.inner;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import androidx.annotation.RequiresPermission;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.location.inner.LocationCallback;
import com.yy.location.inner.LocationPerfStatis;
import com.yy.location.inner.LocationServiceAdapter;
import com.yy.location.inner.NativeLocationServiceAdapter;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/yy/location/inner/NativeLocationServiceAdapter;", "Lcom/yy/location/inner/LocationServiceAdapter;", "()V", "locationManager", "Landroid/location/LocationManager;", "getLocationManager", "()Landroid/location/LocationManager;", "locationManager$delegate", "Lkotlin/Lazy;", "getLatestLocation", "Landroid/location/Location;", "startRequest", "", "locationCallback", "Lcom/yy/location/inner/LocationCallback;", "stopRequest", "Companion", "main_googlePlayBillDebug"})
public final class NativeLocationServiceAdapter
implements LocationServiceAdapter {
    private final Lazy locationManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)locationManager.2.INSTANCE);
    private static final String TAG = "NativeLocationServiceAdapter";
    public static final Companion Companion = new Companion(null);

    private final LocationManager getLocationManager() {
        Lazy lazy = this.locationManager$delegate;
        NativeLocationServiceAdapter nativeLocationServiceAdapter = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LocationManager)lazy.getValue();
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void startRequest(@NotNull LocationCallback locationCallback) {
        Intrinsics.checkParameterIsNotNull((Object)locationCallback, (String)"locationCallback");
        WeakReference<LocationCallback> weakRefCallback = new WeakReference<LocationCallback>(locationCallback);
        long startTime = SystemClock.elapsedRealtime();
        MLog.debug((Object)TAG, (String)"requestLocation", (Object[])new Object[0]);
        LocationPerfStatis.report$default(LocationPerfStatis.INSTANCE, 2, true, 0L, 4, null);
        if (Build.VERSION.SDK_INT >= 30) {
            LocationManager locationManager2 = this.getLocationManager();
            if (locationManager2 != null) {
                Context context = RuntimeContext.sApplicationContext;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
                locationManager2.getCurrentLocation("network", null, context.getMainExecutor(), (Consumer)new Consumer<Location>(startTime, weakRefCallback){
                    final /* synthetic */ long $startTime;
                    final /* synthetic */ WeakReference $weakRefCallback;

                    public final void accept(Location it) {
                        block1: {
                            block0: {
                                long duration = SystemClock.elapsedRealtime() - this.$startTime;
                                MLog.debug((Object)"NativeLocationServiceAdapter", (String)("get location " + it + " cost " + duration + " ms"), (Object[])new Object[0]);
                                if (it == null) break block0;
                                LocationPerfStatis.INSTANCE.report(2, false, duration);
                                LocationCallback locationCallback = (LocationCallback)this.$weakRefCallback.get();
                                if (locationCallback == null) break block1;
                                locationCallback.onLocationResult(it);
                                break block1;
                            }
                            LocationCallback locationCallback = (LocationCallback)this.$weakRefCallback.get();
                            if (locationCallback == null) break block1;
                            locationCallback.onLocationAvailability(false);
                        }
                    }
                    {
                        this.$startTime = l;
                        this.$weakRefCallback = weakReference;
                    }
                });
            }
        } else {
            try {
                LocationManager locationManager3 = this.getLocationManager();
                if (locationManager3 != null) {
                    LocationListener locationListener = new LocationListener(startTime, weakRefCallback){
                        final /* synthetic */ long $startTime;
                        final /* synthetic */ WeakReference $weakRefCallback;

                        public void onLocationChanged(@NotNull Location location) {
                            block0: {
                                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                                long duration = SystemClock.elapsedRealtime() - this.$startTime;
                                MLog.debug((Object)"NativeLocationServiceAdapter", (String)("get location " + location + " cost " + duration + "ms"), (Object[])new Object[0]);
                                LocationPerfStatis.INSTANCE.report(2, false, duration);
                                LocationCallback locationCallback = (LocationCallback)this.$weakRefCallback.get();
                                if (locationCallback == null) break block0;
                                locationCallback.onLocationResult(location);
                            }
                        }

                        public void onProviderDisabled(@NotNull String provider) {
                            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                            LocationCallback locationCallback = (LocationCallback)this.$weakRefCallback.get();
                            if (locationCallback != null) {
                                locationCallback.onLocationAvailability(false);
                            }
                            MLog.debug((Object)"NativeLocationServiceAdapter", (String)"provider disabled!", (Object[])new Object[0]);
                        }

                        public void onProviderEnabled(@NotNull String provider) {
                            Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
                        }

                        public void onStatusChanged(@Nullable String provider, int status, @Nullable Bundle extras) {
                        }
                        {
                            this.$startTime = $captured_local_variable$0;
                            this.$weakRefCallback = $captured_local_variable$1;
                        }
                    };
                    Context context = RuntimeContext.sApplicationContext;
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"RuntimeContext.sApplicationContext");
                    locationManager3.requestSingleUpdate("network", locationListener, context.getMainLooper());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public Location getLatestLocation() {
        Location lastKnowLocation;
        LocationManager locationManager2 = this.getLocationManager();
        Object object = lastKnowLocation = locationManager2 != null ? locationManager2.getLastKnownLocation("network") : null;
        if (lastKnowLocation != null && SystemClock.elapsedRealtimeNanos() - lastKnowLocation.getElapsedRealtimeNanos() < 21600000000000L) {
            return lastKnowLocation;
        }
        LocationManager locationManager3 = this.getLocationManager();
        Object object2 = lastKnowLocation = locationManager3 != null ? locationManager3.getLastKnownLocation("gps") : null;
        if (lastKnowLocation != null && SystemClock.elapsedRealtimeNanos() - lastKnowLocation.getElapsedRealtimeNanos() < 21600000000000L) {
            return lastKnowLocation;
        }
        return null;
    }

    public void stopRequest(@NotNull LocationCallback locationCallback) {
        Intrinsics.checkParameterIsNotNull((Object)locationCallback, (String)"locationCallback");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/location/inner/NativeLocationServiceAdapter$Companion;", "", "()V", "TAG", "", "main_googlePlayBillDebug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

