/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.ui;

import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.voice.base.roomvoice.VoiceRoomMsgDef;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import java.util.Collections;
import org.json.JSONObject;

public class GiftContributionJsEvent
implements JsEvent {
    private static final String TAG = "String";

    @NonNull
    public JsMethod method() {
        return JsEventDefine.UI.openRoomGiftPanel;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, @NonNull String param, @Nullable IJsEventCallback callback) {
        int propId = 0;
        long selectedUid = 0L;
        boolean priorityPacketTab = false;
        String giftTab = "";
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
            propId = jsonObject.optInt("propId", 0);
            selectedUid = jsonObject.optLong("selectedUid", 0L);
            priorityPacketTab = jsonObject.optBoolean("priority_packet", false);
            giftTab = jsonObject.optString("selectTab");
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"json\u89e3\u6790\u5f02\u5e38", (Object[])new Object[0]);
        }
        this.openRoomGiftPanel(propId, priorityPacketTab, callback, selectedUid, giftTab);
    }

    private void openRoomGiftPanel(int propId, boolean priorityPacketTab, @Nullable IJsEventCallback callback, long selectedUid, String tab) {
        Message message = new Message();
        message.what = RuntimeContext.useOldRoom() ? VoiceRoomMsgDef.OPEN_GIFT_PANEL : ChannelBaseMsgDef.OPEN_GIFT_PANEL;
        ShowGiftPanelParam panelParam = new ShowGiftPanelParam(3);
        panelParam.setPropId(propId);
        panelParam.setSelectPropPacketTab(priorityPacketTab);
        panelParam.setSelectedUid(Collections.singletonList(selectedUid));
        panelParam.setGiftTab(tab);
        message.obj = panelParam;
        MsgDispatcher.getInstance().sendMessage(message);
        if (callback != null) {
            callback.callJs((IJsParam)BaseJsParam.successParam((String)"open room gift panel successfully"));
        }
    }
}

