/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import ikxd.through.KxdThrough;
import ikxd.through.Uri;
import ikxd.through.WebMessageNotify;
import ikxd.through.WebMessageReq;
import ikxd.through.WebMessageRes;
import okio.ByteString;

class SocketJsEvent
implements JsEvent {
    private static final String TAG = "SocketJsEvent";
    private final JsEventControllerCallback mControllerCallback;

    SocketJsEvent(@NonNull JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
        this.initWebProtoNotify();
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.sendSocketData;
    }

    public void jsCall(final @NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SocketJsEvent.this.sendSocketData(webHandler, param, callback);
            }
        });
    }

    private void sendSocketData(IWebBusinessHandler webHandler, String paramJson, final @Nullable IJsEventCallback callback) {
        SocketDataParam param;
        MLog.info((Object)TAG, (String)"sendSocketData paramJson: %s, callback: %s", (Object[])new Object[]{paramJson, callback});
        try {
            param = (SocketDataParam)JsonParser.parseJsonObject((String)paramJson, SocketDataParam.class);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)("parse paramJson failed, exception: " + e));
                callback.callJs((IJsParam)err);
            }
            return;
        }
        if (param == null || TextUtils.isEmpty((CharSequence)param.service) || TextUtils.isEmpty((CharSequence)param.name) || TextUtils.isEmpty((CharSequence)param.data)) {
            MLog.error((Object)TAG, (String)"sendSocketData paramJson is illegality", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        WebMessageReq req2 = new WebMessageReq.Builder().service(param.service).name(param.name).data(ByteString.encodeUtf8((String)param.data)).build();
        KxdThrough through = new KxdThrough.Builder().header(ProtoManager.getInstance().getHeader("ikxd_through_d")).uri(Uri.kUriWebMessageReq).web_message_req(req2).build();
        ProtoManager.getInstance().send((AndroidMessage)through, (IProtoCallback)new IProtoCallback<KxdThrough>(){

            public void onResponse(@Nullable KxdThrough msg) {
                if (callback == null) {
                    return;
                }
                if (msg == null) {
                    BaseJsParam err = BaseJsParam.errorParam((int)-10, (String)"parse data from service error");
                    callback.callJs((IJsParam)err);
                } else if (msg.uri == Uri.kUriWebMessageRes) {
                    WebMessageRes res = msg.web_message_res;
                    SocketDataParam resP = SocketDataParam.obtain(res.service, res.name, res.data.utf8());
                    BaseJsParam p = BaseJsParam.dataParam((String)JsonParser.toJson((Object)resP));
                    callback.callJs((IJsParam)p);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)SocketJsEvent.TAG, (String)"send data timeout", (Object[])new Object[0]);
                if (callback != null) {
                    BaseJsParam err = BaseJsParam.errorParam((int)-1, (String)"send data timeout");
                    callback.callJs((IJsParam)err);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)SocketJsEvent.TAG, (String)"send data error, code: %s, reason: %s", (Object[])new Object[]{code, reason});
                if (callback != null) {
                    BaseJsParam err = BaseJsParam.errorParam((int)-2, (String)reason);
                    callback.callJs((IJsParam)err);
                }
                return false;
            }
        });
    }

    private void initWebProtoNotify() {
        ProtoManager.getInstance().registerNotify((IProtoNotify)new IProtoNotify<KxdThrough>(){

            public String serviceName() {
                return "ikxd_through_d";
            }

            public void onNotify(@NonNull KxdThrough msg) {
                if (msg.uri == Uri.kUriWebMessageNotify) {
                    final WebMessageNotify notify = msg.web_message_notify;
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SocketDataParam resP = SocketDataParam.obtain(notify.service, notify.name, notify.data.utf8());
                            SocketJsEvent.this.onNotifySocketData(resP, notify.web_id);
                        }
                    });
                }
            }
        });
    }

    private void onNotifySocketData(final SocketDataParam param, final String webId) {
        final String str = JsonParser.toJson((Object)param);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)SocketJsEvent.TAG, (String)"onNotifySocketData webId: %s, param: %s", (Object[])new Object[]{webId, param});
                ((IWebService)SocketJsEvent.this.mControllerCallback.getService().getService(IWebService.class)).loadNotifyJs(webId, JsEventDefine.NOTIFY.notifySocketData, str);
            }
        });
    }

    static class SocketDataParam {
        @SerializedName(value="service")
        public String service = "";
        @SerializedName(value="name")
        public String name = "";
        @SerializedName(value="data")
        public String data = "";

        SocketDataParam() {
        }

        static SocketDataParam obtain(String service, String name, String data) {
            SocketDataParam param = new SocketDataParam();
            param.service = service;
            param.name = name;
            param.data = data;
            return param;
        }

        public String toString() {
            return "SocketDataParam{service='" + this.service + '\'' + ", name='" + this.name + '\'' + ", data='" + this.data + '\'' + '}';
        }
    }
}

