/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.yylite.commonbase.hiido.HiidoUtils;

class GetLoadStatsJsEvent
implements JsEvent {
    GetLoadStatsJsEvent() {
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.getLoadStats;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, @NonNull String param, @Nullable IJsEventCallback callback) {
        if (callback == null) {
            return;
        }
        WebEnvSettings settings = webHandler.getWebEnvSettings();
        String url = "";
        int cacheHit = -1;
        int resCacheHitWhenStartLoad = -1;
        long resDownloadedTimeAfterStartLoad = -1L;
        int configHit = -1;
        long configLoadedTime = -1L;
        int isDownloadPatch = -1;
        if (settings != null) {
            if (settings.url != null) {
                url = settings.url;
                int index = url.indexOf("?");
                if (index > 0) {
                    url = url.substring(0, index);
                }
                if ((index = url.indexOf("#")) > 0) {
                    url = url.substring(0, index);
                }
            }
            cacheHit = settings.statParams.localZipCacheHit ? 1 : 0;
            configHit = settings.statParams.configHit;
            configLoadedTime = settings.statParams.configLoadedTime;
            resCacheHitWhenStartLoad = settings.statParams.resCacheHitWhenStartLoad;
            resDownloadedTimeAfterStartLoad = settings.statParams.resDownloadedTimeAfterStartLoad;
            if (resCacheHitWhenStartLoad == 0) {
                isDownloadPatch = settings.statParams.resPatchDownloadTypeAfterStartLoad ? 1 : 0;
            }
        }
        final BaseJsParam cbParam = BaseJsParam.builder().put("startTime", (Object)webHandler.getWebViewBeginTime()).put("reuseWeb", (Object)webHandler.isUseCacheWeb()).put("preRender", (Object)(settings != null ? settings.renderMode == 1 : false)).put("uri", (Object)url).put("hdid", (Object)HiidoUtils.getHdid()).put("reqid", (Object)(settings != null ? settings.statParams.reqid : "")).put("cacheHit", (Object)cacheHit).put("configHit", (Object)configHit).put("configLoadedTime", (Object)configLoadedTime).put("resCacheHit", (Object)resCacheHitWhenStartLoad).put("resDownloadedTime", (Object)resDownloadedTimeAfterStartLoad).put("zipMd5", (Object)(settings != null ? settings.statParams.localZipMd5 : "")).put("patchDownloadType", (Object)isDownloadPatch).put("appRunTime", (Object)(SystemClock.uptimeMillis() - RuntimeContext.sAppOncreateTime)).build();
        callback.callJs((IJsParam)cbParam);
        if (RuntimeContext.isInGray()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    MLog.info((Object)"GetLoadStatsJsEvent", (String)"param:%s!", (Object[])new Object[]{cbParam.toString()});
                }
            });
        }
    }
}

