/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.hookview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.ArrayMap;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.env.RuntimeContext;
import com.yy.hiyo.module.setting.envsetting.hookview.ViewBorderDrawable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;

public class ViewInspectUtil {
    private static final String TAG = "Util";

    public static Application getApp() {
        return (Application)RuntimeContext.sApplicationContext;
    }

    @TargetApi(value=19)
    public static Activity getRunningActivity() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            ArrayMap activities = (ArrayMap)activitiesField.get(activityThread);
            for (Object activityRecord : activities.values()) {
                Class<?> activityRecordClass = activityRecord.getClass();
                Field pausedField = activityRecordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (pausedField.getBoolean(activityRecord)) continue;
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                return (Activity)activityField.get(activityRecord);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Didn't find the running activity");
    }

    @SuppressLint(value={"LogUsage"})
    public static String getViewInfo(View v) {
        try {
            ViewInspectUtil.wrapDrawableBorder(v);
            String name = v.getResources().getResourceEntryName(v.getId());
            return name + " : " + v.getClass().getSimpleName();
        }
        catch (Resources.NotFoundException e) {
            Log.e((String)TAG, (String)"getViewName not found");
            return v.getClass().getSimpleName();
        }
    }

    public static void findPage(ViewGroup viewGroup, Stack<ViewGroup> viewStack) {
        if (viewGroup == null) {
            return;
        }
        if (viewGroup.getChildCount() > 0) {
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View view = viewGroup.getChildAt(i);
                String simpleName = view.getClass().getSimpleName();
                if (!(view instanceof ViewGroup)) continue;
                if (simpleName.contains("Page") || simpleName.contains("page")) {
                    viewStack.add((ViewGroup)view);
                }
                ViewInspectUtil.findPage((ViewGroup)view, viewStack);
            }
        }
    }

    public static ViewGroup findTargetViewOwnerPage(Stack<ViewGroup> viewStack, View target) {
        if (viewStack == null) {
            return null;
        }
        while (!viewStack.empty()) {
            ViewGroup group = viewStack.pop();
            View view = group.findViewById(target.getId());
            if (view == null) continue;
            return group;
        }
        return null;
    }

    public static void wrapDrawableBorder(View view) {
        if (view instanceof TextureView) {
            return;
        }
        LayerDrawable newDrawable = null;
        if (view.getBackground() != null) {
            Drawable oldDrawable = view.getBackground();
            if (oldDrawable instanceof LayerDrawable) {
                for (int i = 0; i < ((LayerDrawable)oldDrawable).getNumberOfLayers(); ++i) {
                    if (((LayerDrawable)oldDrawable).getDrawable(i) instanceof ViewBorderDrawable) {
                        return;
                    }
                    if (!(((LayerDrawable)oldDrawable).getDrawable(i) instanceof LayerDrawable)) continue;
                    newDrawable = new LayerDrawable(new Drawable[]{new ViewBorderDrawable(view)});
                    break;
                }
                if (newDrawable == null) {
                    newDrawable = new LayerDrawable(new Drawable[]{oldDrawable, new ViewBorderDrawable(view)});
                }
            } else {
                newDrawable = new LayerDrawable(new Drawable[]{oldDrawable, new ViewBorderDrawable(view)});
            }
        } else {
            newDrawable = new LayerDrawable(new Drawable[]{new ViewBorderDrawable(view)});
        }
        try {
            view.setBackground((Drawable)newDrawable);
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    public static void clearViewBorder(View view) {
        if (view instanceof ViewGroup) {
            ViewInspectUtil.clearDrawable(view);
            int childCount = ((ViewGroup)view).getChildCount();
            if (childCount != 0) {
                for (int index = 0; index < childCount; ++index) {
                    ViewInspectUtil.clearViewBorder(((ViewGroup)view).getChildAt(index));
                }
            }
        } else {
            ViewInspectUtil.clearDrawable(view);
        }
    }

    private static void clearDrawable(View view) {
        if (view == null || view.getBackground() == null) {
            return;
        }
        Drawable oldDrawable = view.getBackground();
        if (!(oldDrawable instanceof LayerDrawable)) {
            return;
        }
        LayerDrawable layerDrawable = (LayerDrawable)oldDrawable;
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        for (int i = 0; i < layerDrawable.getNumberOfLayers(); ++i) {
            if (layerDrawable.getDrawable(i) instanceof ViewBorderDrawable) continue;
            drawables.add(layerDrawable.getDrawable(i));
        }
        LayerDrawable newDrawable = new LayerDrawable(drawables.toArray(new Drawable[drawables.size()]));
        view.setBackground((Drawable)newDrawable);
    }

    public static LinkedList<View> buildTarget2RootChain(View targetView) {
        LinkedList<View> list = new LinkedList<View>();
        View v = targetView;
        Class<?> decorClass = null;
        try {
            decorClass = Class.forName("com.android.internal.policy.DecorView");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        while (v != null) {
            list.add(v);
            if (v.getClass() == decorClass) break;
            v = (View)v.getParent();
        }
        return list;
    }
}

