/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.hookview;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.hiyo.module.setting.envsetting.hookview.NotHook;

public class FloatingMagnetView
extends FrameLayout
implements NotHook {
    public static final int MARGIN_EDGE = -600;
    private float mOriginalRawX;
    private float mOriginalRawY;
    private float mOriginalX;
    private float mOriginalY;
    private static final int TOUCH_TIME_THRESHOLD = 150;
    private long mLastTouchDownTime;
    protected MoveAnimator mMoveAnimator;
    protected int mScreenWidth;
    private int mScreenHeight;
    private boolean isNearestLeft = true;
    private float mPortraitY;

    public FloatingMagnetView(Context context) {
        this(context, null);
    }

    public FloatingMagnetView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FloatingMagnetView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mMoveAnimator = new MoveAnimator();
        this.setClickable(true);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event == null) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.changeOriginalTouchParams(event);
                this.updateSize();
                this.mMoveAnimator.stop();
                break;
            }
            case 2: {
                this.updateViewPosition(event);
                break;
            }
            case 1: {
                this.clearPortraitY();
                this.moveToEdge();
                if (!this.isOnClickEvent()) break;
                this.dealClickEvent();
            }
        }
        return true;
    }

    protected void dealClickEvent() {
    }

    protected boolean isOnClickEvent() {
        return System.currentTimeMillis() - this.mLastTouchDownTime < 150L;
    }

    private void updateViewPosition(MotionEvent event) {
        this.setX(this.mOriginalX + event.getRawX() - this.mOriginalRawX);
        float desY = this.mOriginalY + event.getRawY() - this.mOriginalRawY;
        if (desY < 0.0f) {
            desY = 0.0f;
        }
        if (desY > (float)(this.mScreenHeight - this.getHeight())) {
            desY = this.mScreenHeight - this.getHeight();
        }
        this.setY(desY);
    }

    private void changeOriginalTouchParams(MotionEvent event) {
        this.mOriginalX = this.getX();
        this.mOriginalY = this.getY();
        this.mOriginalRawX = event.getRawX();
        this.mOriginalRawY = event.getRawY();
        this.mLastTouchDownTime = System.currentTimeMillis();
    }

    protected void updateSize() {
        ViewGroup viewGroup = (ViewGroup)this.getParent();
        if (viewGroup != null) {
            this.mScreenWidth = viewGroup.getWidth() - this.getWidth();
            this.mScreenHeight = viewGroup.getHeight();
        }
    }

    public void moveToEdge() {
        this.moveToEdge(this.isNearestLeft(), false);
    }

    public void moveToEdge(boolean isLeft, boolean isLandscape) {
        float destinationX = isLeft ? Math.max(this.getX(), -600.0f) : Math.min(this.getX(), (float)(this.mScreenWidth - -600));
        float y = this.getY();
        if (!isLandscape && this.mPortraitY != 0.0f) {
            y = this.mPortraitY;
            this.clearPortraitY();
        }
        this.mMoveAnimator.start(destinationX, Math.min(Math.max(0.0f, y), (float)(this.mScreenHeight - this.getHeight())));
    }

    private void clearPortraitY() {
        this.mPortraitY = 0.0f;
    }

    protected boolean isNearestLeft() {
        int middle = this.mScreenWidth / 2;
        this.isNearestLeft = this.getX() < (float)middle;
        return this.isNearestLeft;
    }

    private void move(float deltaX, float deltaY) {
        this.setX(this.getX() + deltaX);
        this.setY(this.getY() + deltaY);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.getParent() != null) {
            final boolean isLandscape = newConfig.orientation == 2;
            this.markPortraitY(isLandscape);
            ((ViewGroup)this.getParent()).post(new Runnable(){

                @Override
                public void run() {
                    FloatingMagnetView.this.updateSize();
                    FloatingMagnetView.this.moveToEdge(FloatingMagnetView.this.isNearestLeft, isLandscape);
                }
            });
        }
    }

    private void markPortraitY(boolean isLandscape) {
        if (isLandscape) {
            this.mPortraitY = this.getY();
        }
    }

    protected class MoveAnimator
    implements Runnable {
        private Handler handler = new Handler(Looper.getMainLooper());
        private float destinationX;
        private float destinationY;
        private long startingTime;

        protected MoveAnimator() {
        }

        void start(float x, float y) {
            this.destinationX = x;
            this.destinationY = y;
            this.startingTime = System.currentTimeMillis();
            this.handler.post((Runnable)this);
        }

        @Override
        public void run() {
            if (FloatingMagnetView.this.getRootView() == null || FloatingMagnetView.this.getRootView().getParent() == null) {
                return;
            }
            float progress = Math.min(1.0f, (float)(System.currentTimeMillis() - this.startingTime) / 400.0f);
            float deltaX = (this.destinationX - FloatingMagnetView.this.getX()) * progress;
            float deltaY = (this.destinationY - FloatingMagnetView.this.getY()) * progress;
            FloatingMagnetView.this.move(deltaX, deltaY);
            if (progress < 1.0f) {
                this.handler.post((Runnable)this);
            }
        }

        private void stop() {
            this.handler.removeCallbacks((Runnable)this);
        }
    }
}

