/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.hagologanalyse.parser;

import android.os.Environment;
import android.util.Log;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.Config;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.data.LogItem;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.parser.HeadParser;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.parser.TagParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;

public class LineParser {
    private static final String TAG = "LogAnalyser";
    public static int STAT_LEVEL = Config.sLogLevel;
    public static int TAG_TYPE = Config.sTagLayer;
    private static boolean sHeadMatched = false;
    private static LogItem sLastLogItem;
    private static final HashMap<String, LogItem> sItems;
    private static int sAllNum;

    public static void resetItems() {
        sAllNum = 0;
        sItems.clear();
    }

    public static void fillPercent(LogItem item) {
        item.percent = item.charNum * 100 / sAllNum;
    }

    public static Collection<LogItem> getItems() {
        return sItems.values();
    }

    public static void parseLine(String line) {
        if (line == null || line.length() == 0) {
            return;
        }
        String lineOrigin = line;
        int lineOriginLength = line.length();
        boolean headMatched = HeadParser.parseHead(line);
        if (!headMatched) {
            if (sHeadMatched) {
                sAllNum += line.length();
                LineParser.sLastLogItem.charNum += line.length();
            }
            return;
        }
        int levelEndIndex = LineParser.levelEndIndex(STAT_LEVEL, line = line.substring(12));
        if (levelEndIndex < 0) {
            Log.e((String)TAG, (String)"level is too low!");
            return;
        }
        if ((line = line.substring(levelEndIndex)).startsWith("[LISE]")) {
            line = line.substring(6);
        }
        if ((levelEndIndex = line.indexOf("]")) < 0) {
            Log.e((String)TAG, (String)"level is too low!");
            return;
        }
        String tag = TagParser.parseTag(TAG_TYPE, line = line.substring(levelEndIndex + 1));
        if (tag != null && tag.length() > 0) {
            sHeadMatched = true;
            sLastLogItem = sItems.get(tag);
            if (sLastLogItem == null) {
                sLastLogItem = new LogItem();
                LineParser.sLastLogItem.tag = tag;
                sItems.put(tag, sLastLogItem);
            }
            LineParser.sLastLogItem.lines.add(lineOrigin + "\n");
            sAllNum += lineOriginLength;
            LineParser.sLastLogItem.charNum += lineOriginLength;
        }
    }

    private static int levelEndIndex(int statLevel, String line) {
        int index = -1;
        if (statLevel <= 1) {
            index = line.indexOf(" V/");
        }
        if (index >= 0) {
            return index + " V/".length();
        }
        if (statLevel <= 2) {
            index = line.indexOf(" D/");
        }
        if (index >= 0) {
            return index + " D/".length();
        }
        if (statLevel <= 3) {
            index = line.indexOf(" I/");
        }
        if (index >= 0) {
            return index + " I/".length();
        }
        if (statLevel <= 4) {
            index = line.indexOf(" W/");
        }
        if (index >= 0) {
            return index + " W/".length();
        }
        if (statLevel <= 5) {
            index = line.indexOf(" E/");
        }
        if (index >= 0) {
            return index + " E/".length();
        }
        return -1;
    }

    static {
        sItems = new HashMap(5000);
        try {
            InputStreamReader inputreader;
            BufferedReader buffreader;
            String line;
            FileInputStream instream;
            String path = Environment.getExternalStorageDirectory().getPath();
            File logAnalyserConfig = new File(path + File.separator + "logAnalyserConfig.txt");
            if (logAnalyserConfig.exists() && (instream = new FileInputStream(logAnalyserConfig)) != null && (line = (buffreader = new BufferedReader(inputreader = new InputStreamReader(instream))).readLine()) != null) {
                if ((line = line.replace('\n', ' ')).equals("1")) {
                    STAT_LEVEL = 1;
                } else if (line.equals("2")) {
                    STAT_LEVEL = 2;
                } else if (line.equals("3")) {
                    STAT_LEVEL = 3;
                } else if (line.equals("4")) {
                    STAT_LEVEL = 4;
                } else if (line.equals("5")) {
                    STAT_LEVEL = 5;
                }
                Log.e((String)TAG, (String)("read logAnalyserConfig.txt line:" + line));
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("read logAnalyserConfig.txt error:" + e.toString()));
        }
        sAllNum = 0;
    }
}

