/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.hagologanalyse;

import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.Sorter;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.data.LogItem;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.parser.LineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Analyser {
    public static Context sContext;
    private static final String TAG = "LogAnalyser";

    public static ArrayList<LogItem> parseFile(File file) {
        File[] fileArray;
        if (file == null || !file.exists()) {
            MLog.error((Object)TAG, (String)("file error:" + (file == null ? "null" : file.toString())), (Object[])new Object[0]);
        }
        LineParser.resetItems();
        if (file.isDirectory()) {
            fileArray = file.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        File[] files = fileArray;
        try {
            for (File item : files) {
                String line;
                FileInputStream instream;
                if (item.isDirectory() || (instream = new FileInputStream(item)) == null) continue;
                InputStreamReader inputreader = new InputStreamReader(instream);
                BufferedReader buffreader = new BufferedReader(inputreader);
                while ((line = buffreader.readLine()) != null) {
                    LineParser.parseLine(line);
                }
                ((InputStream)instream).close();
            }
        }
        catch (FileNotFoundException e) {
            MLog.error((Object)TAG, (String)("read file error:The File doesn't not exist." + e), (Object[])new Object[0]);
            ToastUtils.showToast((Context)sContext, (String)"read file error:The File doesn't not exist!", (int)1);
        }
        catch (IOException e) {
            MLog.error((Object)TAG, (String)("read file error:" + e.getMessage()), (Object[])new Object[0]);
            ToastUtils.showToast((Context)sContext, (String)("read file error:" + e.getMessage()), (int)1);
        }
        ArrayList<LogItem> items = Sorter.sort(LineParser.getItems());
        if (items != null && items.size() > 0) {
            int sizeToSave = items.size() > 50 ? 50 : items.size();
            ArrayList<LogItem> finalItems = new ArrayList<LogItem>(sizeToSave);
            StringBuilder logBuilder = new StringBuilder();
            LogItem item = null;
            for (int i = 0; i < sizeToSave; ++i) {
                item = items.get(i);
                LineParser.fillPercent(item);
                finalItems.add(item);
                logBuilder.append("size:" + item.charNum + " " + item.percent + "% tag:" + item.tag + "\n");
            }
            Log.i((String)TAG, (String)"parseFile success!");
            Log.i((String)TAG, (String)("result:" + logBuilder.toString()));
            return finalItems;
        }
        Log.e((String)TAG, (String)"analyser error:items is empty!");
        Toast.makeText((Context)sContext, (CharSequence)"analyser error:items is empty!", (int)1);
        return null;
    }
}

