/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.preconnect;

import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.unifyconfig.config.HostPreConnectConfig;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceWrapper;
import com.yy.base.utils.SettingFlags;
import com.yy.grace.NetworkConverter;
import com.yy.grace.Request;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.hiyo.login.account.AccountModel;
import java.util.List;

public class HostPreConnectManager {
    private static final String TAG = "HostPreConnectManager";
    private static final long PRE_CONNECT_TIME_INTERVAL = 300000L;
    private long mStartChannelPreConnectTime = 0L;
    private long mStartRechargePreConnectTime = 0L;

    private HostPreConnectManager() {
    }

    public static HostPreConnectManager getInstance() {
        return SingleHolder.INSTANCE;
    }

    public void preConnectLogin() {
        if (AccountModel.isExistLoginedAccount()) {
            MLog.info((Object)TAG, (String)"preConnectLogin cancel, logined", (Object[])new Object[0]);
            return;
        }
        if (HostPreConnectManager.isNotEnablePreConnect()) {
            return;
        }
        List lists = HostPreConnectConfig.getLoginHostNetWorkMapArrayList();
        if (lists.size() == 0) {
            NetworkConverter.Factory.PreHost preHost = new NetworkConverter.Factory.PreHost(UriProvider.getLoginHost(), (Request.Group)BizScenc.NORMAL_LOGIN);
            MLog.info((Object)TAG, (String)("preConnectLogin host: " + UriProvider.getLoginHost()), (Object[])new Object[0]);
            lists.add(preHost);
            MLog.info((Object)TAG, (String)"using default login host", (Object[])new Object[0]);
        }
        GraceWrapper.getGrace().preConnect(lists);
    }

    public void preConnectChannel() {
        if (HostPreConnectManager.isNotEnablePreConnect()) {
            return;
        }
        long interval = System.currentTimeMillis() - this.mStartChannelPreConnectTime;
        if (interval > 300000L) {
            this.mStartChannelPreConnectTime = System.currentTimeMillis();
            GraceWrapper.getGrace().preConnect(HostPreConnectConfig.getChannelHostNetWorkMapArrayList());
        }
    }

    public void preConnectRecharge() {
        if (HostPreConnectManager.isNotEnablePreConnect()) {
            return;
        }
        long interval = System.currentTimeMillis() - this.mStartRechargePreConnectTime;
        if (interval > 300000L) {
            this.mStartRechargePreConnectTime = System.currentTimeMillis();
            GraceWrapper.getGrace().preConnect(HostPreConnectConfig.getRechargeHostNetWorkMapArrayList());
        }
    }

    public static boolean isNotEnablePreConnect() {
        return !SettingFlags.getBoolean((String)"key_pre_connect_enable", (boolean)true);
    }

    private static final class SingleHolder {
        private static final HostPreConnectManager INSTANCE = new HostPreConnectManager();

        private SingleHolder() {
        }
    }
}

