/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.yytask;

import android.os.SystemClock;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.config.taskopt.TaskOptConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.IIdleExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.module.performancemonitor.perfcollect.yytask.IdleExecutor;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;

public class TaskExecutorMonitor {
    private static long lastHappenQueueBlockedTime = 0L;
    private static long runningTasksLogTime = 0L;
    private static ArrayList<Runnable> sRunningItems;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initYYTaskExecutorMonitor() {
        if (SystemUtils.isShowEnvSetting() || TaskOptConfig.isIdleExecuteSwitch()) {
            YYTaskExecutor.setIdleExecutorProxy((YYTaskExecutor.IIdleExecutorProxy)new YYTaskExecutor.IIdleExecutorProxy(){

                public IIdleExecutor createAIdleExecutor(String id2) {
                    return new IdleExecutor(id2);
                }
            });
        }
        if (!(SystemUtils.isShowEnvSetting() || SettingFlags.getBoolean((String)"yytaskcrashreport2", (boolean)false) && SettingFlagBaseKeys.isNormalMetricSwitchOn())) {
            YYTaskExecutor.setTaskMonitor(null);
            Class<TaskExecutorMonitor> clazz = TaskExecutorMonitor.class;
            synchronized (TaskExecutorMonitor.class) {
                if (sRunningItems != null) {
                    sRunningItems.clear();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
        YYTaskExecutor.setTaskMonitor((YYTaskExecutor.ITaskMonitor)new YYTaskExecutor.ITaskMonitor(){

            public void onTaskRejectedExecution(Runnable task) {
                String taskStr;
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", 1);
                statContent.put("sfield", String.valueOf(AccountUtil.getUid()));
                String string2 = taskStr = task != null ? task.toString() : "";
                if (StringUtils.isNotEmpty((String)taskStr) && taskStr.length() > 300) {
                    taskStr = taskStr.substring(0, 300);
                }
                statContent.put("sfieldthree", taskStr);
                statContent.put("perftype", "yytaskmonitor_exc");
                HiidoStatis.reportContent((StatisContent)statContent);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTaskException(Throwable e, Runnable task) {
                Class<TaskExecutorMonitor> clazz = TaskExecutorMonitor.class;
                synchronized (TaskExecutorMonitor.class) {
                    String taskStr;
                    String excStr;
                    if (sRunningItems != null) {
                        sRunningItems.remove(task);
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("ifield", 1);
                    statContent.put("sfield", String.valueOf(AccountUtil.getUid()));
                    String string2 = excStr = e != null ? e.toString() : "";
                    if (StringUtils.isNotEmpty((String)excStr) && excStr.length() > 300) {
                        excStr = excStr.substring(0, 300);
                    }
                    statContent.put("sfieldtwo", excStr);
                    String string3 = taskStr = task != null ? task.toString() : "";
                    if (StringUtils.isNotEmpty((String)taskStr) && taskStr.length() > 300) {
                        taskStr = taskStr.substring(0, 300);
                    }
                    statContent.put("sfieldthree", taskStr);
                    statContent.put("perftype", "yytaskmonitor_exc");
                    HiidoStatis.reportContent((StatisContent)statContent);
                    return;
                }
            }

            public void onTaskStartInMainThread(long submitTime, Runnable task) {
                TaskExecutorMonitor.onTaskStart(submitTime, task, true);
            }

            public void onTaskExecutedInMainThread(long submitTime, Runnable task) {
                TaskExecutorMonitor.onTaskExecuted(submitTime, task, true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTaskRealStartExecute(long submitTime, long startExecuteTime, Runnable task, ThreadPoolExecutor threadPool) {
                TaskExecutorMonitor.onTaskStart(submitTime, task, false);
                Class<TaskExecutorMonitor> clazz = TaskExecutorMonitor.class;
                synchronized (TaskExecutorMonitor.class) {
                    long useTime;
                    long timeGap;
                    if (sRunningItems == null) {
                        sRunningItems = new ArrayList(60);
                    }
                    sRunningItems.add(task);
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    long l = timeGap = SystemUtils.isShowEnvSetting() ? 3000L : (long)SettingFlags.getIntValue((String)"yytaskwaittimeout", (int)5000);
                    if (task == null || startExecuteTime - lastHappenQueueBlockedTime < timeGap) {
                        return;
                    }
                    lastHappenQueueBlockedTime = startExecuteTime;
                    if (submitTime > 0L && (useTime = startExecuteTime - submitTime) > timeGap) {
                        long poolWaitSize = -1L;
                        try {
                            poolWaitSize = threadPool.getQueue().size();
                        }
                        catch (Throwable e) {
                            MLog.error((Object)"YYTaskExecutor_Monitor", (Throwable)e);
                        }
                        MLog.warn((Object)"YYTaskExecutor_Monitor", (String)"Task %s waiting too Long Time %d QueueSize: %d", (Object[])new Object[]{task, startExecuteTime - submitTime, poolWaitSize});
                        if (RuntimeContext.sIsDebuggable) {
                            return;
                        }
                        StatisContent statContent = new StatisContent();
                        statContent.put("act", "hagoperf");
                        statContent.put("ifield", useTime);
                        statContent.put("ifieldtwo", poolWaitSize);
                        if (RuntimeContext.sIsForeground) {
                            statContent.put("ifieldthree", RuntimeContext.sHappenLowMemWarn ? 2 : 1);
                        } else {
                            statContent.put("ifieldthree", RuntimeContext.sHappenLowMemWarn ? 4 : 3);
                        }
                        statContent.put("ifieldfour", RuntimeContext.getForeGroundRunTime());
                        statContent.put("sfield", String.valueOf(AccountUtil.getUid()));
                        statContent.put("sfieldtwo", TaskExecutorMonitor.getTaskInfo(task));
                        statContent.put("sfieldthree", RuntimeContext.sCurWin != null ? RuntimeContext.sCurWin : "");
                        if (SystemUtils.isShowEnvSetting()) {
                            statContent.put("sfieldfour", String.valueOf(threadPool.getActiveCount()));
                        }
                        statContent.put("perftype", "yytaskmonitor_wait");
                        HiidoStatis.reportContent((StatisContent)statContent);
                    }
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTaskExecuted(long submitTime, long startExecuteTime, Runnable task, ThreadPoolExecutor threadPool) {
                if (task == null) {
                    return;
                }
                TaskExecutorMonitor.onTaskExecuted(startExecuteTime, task, false);
                long poolWaitSize = -1L;
                Class<TaskExecutorMonitor> clazz = TaskExecutorMonitor.class;
                synchronized (TaskExecutorMonitor.class) {
                    long timeGap;
                    if (sRunningItems != null) {
                        sRunningItems.remove(task);
                        if (SystemUtils.isShowEnvSetting() && SystemClock.uptimeMillis() - runningTasksLogTime > 5000L) {
                            try {
                                poolWaitSize = threadPool.getQueue().size();
                            }
                            catch (Throwable e) {
                                MLog.error((Object)"YYTaskExecutor_Monitor", (Throwable)e);
                            }
                            runningTasksLogTime = SystemClock.uptimeMillis();
                            MLog.warn((Object)"YYTaskExecutor_Monitor", (String)"running task size:%d, queue task size:%d", (Object[])new Object[]{sRunningItems.size(), poolWaitSize});
                        }
                    }
                    // ** MonitorExit[var9_6] (shouldn't be in output)
                    if (task == null || submitTime <= 0L || startExecuteTime <= 0L) {
                        return;
                    }
                    long useTime = SystemClock.uptimeMillis() - startExecuteTime;
                    long l = timeGap = SystemUtils.isShowEnvSetting() ? 5000L : (long)SettingFlags.getIntValue((String)"yytaskexetimeout", (int)8000);
                    if (useTime > timeGap) {
                        try {
                            poolWaitSize = threadPool.getQueue().size();
                        }
                        catch (Throwable e) {
                            MLog.error((Object)"YYTaskExecutor_Monitor", (Throwable)e);
                        }
                        MLog.warn((Object)"YYTaskExecutor_Monitor", (String)"Task %s had token too Long Time %d ", (Object[])new Object[]{task, useTime});
                        if (RuntimeContext.sIsDebuggable) {
                            return;
                        }
                        StatisContent statContent = new StatisContent();
                        statContent.put("act", "hagoperf");
                        statContent.put("ifield", useTime);
                        statContent.put("ifieldtwo", poolWaitSize);
                        if (RuntimeContext.sIsForeground) {
                            statContent.put("ifieldthree", RuntimeContext.sHappenLowMemWarn ? 2 : 1);
                        } else {
                            statContent.put("ifieldthree", RuntimeContext.sHappenLowMemWarn ? 4 : 3);
                        }
                        statContent.put("ifieldfour", RuntimeContext.getForeGroundRunTime());
                        statContent.put("ifieldfive", useTime + startExecuteTime - submitTime);
                        statContent.put("sfield", String.valueOf(AccountUtil.getUid()));
                        statContent.put("sfieldtwo", TaskExecutorMonitor.getTaskInfo(task));
                        statContent.put("sfieldthree", RuntimeContext.sCurWin != null ? RuntimeContext.sCurWin : "");
                        statContent.put("sfieldfour", TaskExecutorMonitor.getRunningTaskInfo());
                        if (SystemUtils.isShowEnvSetting()) {
                            statContent.put("sfieldfive", String.valueOf(threadPool.getActiveCount()));
                        }
                        statContent.put("perftype", "yytaskmonitor_exe");
                        HiidoStatis.reportContent((StatisContent)statContent);
                    }
                    return;
                }
            }

            public void onTaskProbablyEndlessLoop(Runnable task, int executeTimes, int type2) {
                if (SystemUtils.isShowEnvSetting()) {
                    if (type2 == 1) {
                        throw new RuntimeException("task:" + TaskExecutorMonitor.getTaskInfo(task) + ", maybe happen EndlessLoop, excute num:" + executeTimes + ",in one minute!");
                    }
                    if (type2 == 2) {
                        throw new RuntimeException("task:" + TaskExecutorMonitor.getTaskInfo(task) + ", maybe happen EndlessLoop, excute num:" + executeTimes + ",in five second!");
                    }
                    if (type2 == 3) {
                        throw new RuntimeException("queuetask:" + TaskExecutorMonitor.getTaskInfo(task) + ", maybe happen EndlessLoop, consume time:" + executeTimes + "!");
                    }
                } else {
                    MLog.error((Object)"YYTaskExecutor.ITaskMonitor", (String)("task:" + TaskExecutorMonitor.getTaskInfo(task) + ", maybe happen EndlessLoop, excute num:" + executeTimes + ",type" + type2), (Object[])new Object[0]);
                }
            }

            public long getOneMinuteNumLimit() {
                return 4000L;
            }

            public long getFiveSecondNumLimit() {
                return 2000L;
            }
        });
    }

    private static String getTaskInfo(Runnable task) {
        if (task == null) {
            return "";
        }
        String info = task.toString();
        if (info != null) {
            String[] strings = info.split("@", 2);
            return strings[0];
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRunningTaskInfo() {
        int i = 0;
        Class<TaskExecutorMonitor> clazz = TaskExecutorMonitor.class;
        synchronized (TaskExecutorMonitor.class) {
            if (sRunningItems != null) {
                StringBuilder stringBuilder = new StringBuilder("RunningTasks size:" + sRunningItems.size() + " info:");
                for (Runnable task : sRunningItems) {
                    if (task == null) continue;
                    stringBuilder.append(task.toString());
                    stringBuilder.append("\n");
                    if (++i != 80) continue;
                    break;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return stringBuilder.toString();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return "";
        }
    }

    private static void onTaskStart(long submitTime, Runnable task, boolean isMainThread) {
    }

    private static void onTaskExecuted(long submitTime, Runnable task, boolean isMainThread) {
        if (!SystemUtils.isShowEnvSetting()) {
            return;
        }
        String taskInfo = TaskExecutorMonitor.getTaskInfo(task);
        if (taskInfo.contains("GSLBDnsExecuto") || taskInfo.contains("HeartBeatTask") || taskInfo.contains("ProtoPreventDuplicateSender") || taskInfo.contains("HttpRequestPreventDuplicateUtil") || taskInfo.contains("HiidoExecutor$HiidoRunnable") || taskInfo.contains("hiidostatis") || taskInfo.contains("ProtoInnerImp$")) {
            return;
        }
        PerfActionLog.add((String)("Task_" + taskInfo + " consume:" + (SystemClock.uptimeMillis() - submitTime) + " inMain:" + (isMainThread ? 1 : 0)), (Object[])new Object[0]);
    }
}

