/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.window;

import android.view.ViewGroup;
import android.view.ViewParent;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.AbstractWindow;

public class WindowRecycler
implements RecycleImageView.IWindowInvisibleRecycler {
    private boolean needInChannel;
    private boolean needLowMem;

    public WindowRecycler(boolean needInChannel, boolean needLowMem) {
        this.needInChannel = needInChannel;
        this.needLowMem = needLowMem;
    }

    public boolean canRecycle(RecycleImageView recycleImageView) {
        if (this.needInChannel && StringUtils.isEmpty((String)RuntimeContext.getChannelId())) {
            return false;
        }
        if (this.needLowMem && !RuntimeContext.sHappenLowMemWarn) {
            return false;
        }
        AbstractWindow window = null;
        ViewParent parent = recycleImageView.getParent();
        if (parent instanceof AbstractWindow) {
            window = (AbstractWindow)parent;
        } else if (parent instanceof ViewGroup) {
            do {
                ViewParent curView;
                if (!((parent = (curView = parent).getParent()) instanceof AbstractWindow)) continue;
                window = (AbstractWindow)parent;
                break;
            } while (parent instanceof ViewGroup);
        }
        return window != null && !this.isWindowInWhiteList(window.getName());
    }

    private boolean isWindowInWhiteList(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return false;
        }
        if (StringUtils.equal((String)name, (String)"ChannelWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"VoiceRoom")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"RoomProfileWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"ChannelEditAvatarWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"ChannelCreateWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"ChannelInviteListWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"ChannelPermissionSettingWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"ChannelProfileEditWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"ChannelAddBlackWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"MicUpResultWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"MicUpGuideWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"SongRepoWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"KtvMusicListWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"KtvWorksWindow")) {
            return true;
        }
        if (StringUtils.equal((String)name, (String)"KTVScan")) {
            return true;
        }
        return StringUtils.equal((String)name, (String)"ChannelListWindow");
    }
}

