/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.svga;

import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.opensource.svgaplayer.SVGADrawable;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.ui.widget.ICanAutoPause;
import com.yy.appbase.util.FunctionReporter;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.svga.SvgaLoader;
import java.util.ArrayList;

public class SvgaAutoPause {
    private static IRecoverInterceptor sRecoverInterceptor;

    public static void startOrPause() {
        SvgaLoader.setSvgaRecycleHangler((SvgaLoader.ISvgaRecycleHangler)new SvgaLoader.ISvgaRecycleHangler(){

            public void restartAllSvga(ViewGroup viewGroup) {
                if (viewGroup != null) {
                    SvgaAutoPause.restartAllSvga(viewGroup);
                }
            }

            public void pauseAllSvga(ViewGroup viewGroup) {
                if (viewGroup != null) {
                    SvgaAutoPause.pauseAllSvga(viewGroup);
                }
            }
        });
    }

    private static void obtainAllSvgaImageViews(ViewGroup window, ArrayList<SVGAImageView> svgaImageViews, ArrayList<View> mAnimationViews, ArrayList<ICanAutoPause> autoPauseTargets, boolean toRestart) {
        View view;
        ViewGroup viewGroup = window;
        if (sRecoverInterceptor != null && toRestart && (view = sRecoverInterceptor.getRecoverView(viewGroup)) != viewGroup) {
            if (view instanceof ViewGroup) {
                viewGroup = (ViewGroup)view;
                SvgaAutoPause.obtainAllSvgaImageViews(viewGroup, svgaImageViews, mAnimationViews, autoPauseTargets, toRestart);
            } else if (view instanceof ImageView) {
                if (view instanceof SVGAImageView) {
                    svgaImageViews.add((SVGAImageView)view);
                } else {
                    if (view.getAnimation() != null && view.getAnimation().getRepeatCount() == -1) {
                        mAnimationViews.add(view);
                    }
                    if (view instanceof ICanAutoPause) {
                        autoPauseTargets.add((ICanAutoPause)view);
                    }
                }
            }
            return;
        }
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null) continue;
            if (child instanceof ViewGroup) {
                SvgaAutoPause.obtainAllSvgaImageViews((ViewGroup)child, svgaImageViews, mAnimationViews, autoPauseTargets, toRestart);
            } else if (child instanceof SVGAImageView) {
                svgaImageViews.add((SVGAImageView)child);
            }
            if (child.getAnimation() != null && child.getAnimation().getRepeatCount() == -1) {
                mAnimationViews.add(child);
            }
            if (!(child instanceof ICanAutoPause)) continue;
            autoPauseTargets.add((ICanAutoPause)child);
        }
    }

    public static void pauseAllSvga(final ViewGroup window) {
        int switchType = SettingFlags.getIntValue((String)"svgaautopause", (int)1);
        if (switchType != 1 && switchType != 2) {
            return;
        }
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)"SvgaAutoPause", (String)"pauseAllSvga:%s", (Object[])new Object[]{window});
        }
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SvgaAutoPause.pauseAllSvgaInner(window);
                }
            });
        } else if (switchType == 1) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SvgaAutoPause.pauseAllSvgaInner(window);
                }
            });
        } else {
            SvgaAutoPause.pauseAllSvgaInner(window);
        }
    }

    private static void pauseAllSvgaInner(ViewGroup window) {
        ArrayList<SVGAImageView> svgaImageViews = new ArrayList<SVGAImageView>();
        ArrayList<View> mAnimationViews = new ArrayList<View>();
        ArrayList<ICanAutoPause> autoPauseTargets = new ArrayList<ICanAutoPause>();
        SvgaAutoPause.obtainAllSvgaImageViews(window, svgaImageViews, mAnimationViews, autoPauseTargets, false);
        if (svgaImageViews.size() > 0) {
            long curTime = SystemClock.uptimeMillis();
            int count = 0;
            for (SVGAImageView imageView : svgaImageViews) {
                if (!SvgaAutoPause.pauseSvga(imageView)) continue;
                ++count;
            }
            if (count > 0) {
                FunctionReporter.statFunctionWorked((String)"AutoPauseSvga", (int)count, (long)(SystemClock.uptimeMillis() - curTime));
            }
        }
        if (mAnimationViews.size() > 0) {
            for (int i = 0; i < mAnimationViews.size(); ++i) {
                SvgaAutoPause.pauseAnimation(mAnimationViews.get(i));
            }
        }
        if (autoPauseTargets.size() > 0) {
            for (int i = 0; i < autoPauseTargets.size(); ++i) {
                ICanAutoPause target = autoPauseTargets.get(i);
                target.onAutoPause();
            }
        }
    }

    public static void restartAllSvga(final ViewGroup window) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)"SvgaAutoPause", (String)"restartAllSvga:%s", (Object[])new Object[]{window});
        }
        int switchType = SettingFlags.getIntValue((String)"svgaautopause", (int)1);
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SvgaAutoPause.restartAllSvgaInner(window);
                }
            });
        } else if (switchType == 1) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    SvgaAutoPause.restartAllSvgaInner(window);
                }
            });
        } else {
            SvgaAutoPause.restartAllSvgaInner(window);
        }
    }

    private static void restartAllSvgaInner(ViewGroup window) {
        if (SvgaAutoPause.closeRecovery()) {
            return;
        }
        ArrayList<SVGAImageView> svgaImageViews = new ArrayList<SVGAImageView>();
        ArrayList<View> mAnimationViews = new ArrayList<View>();
        ArrayList<ICanAutoPause> autoPauseTargets = new ArrayList<ICanAutoPause>();
        SvgaAutoPause.obtainAllSvgaImageViews(window, svgaImageViews, mAnimationViews, autoPauseTargets, true);
        if (svgaImageViews.size() > 0) {
            for (SVGAImageView imageView : svgaImageViews) {
                SvgaAutoPause.resumeSvga(imageView);
            }
        }
        if (mAnimationViews.size() > 0) {
            for (int i = 0; i < mAnimationViews.size(); ++i) {
                View v = mAnimationViews.get(i);
                SvgaAutoPause.resumeAnimation(v);
            }
        }
        if (autoPauseTargets.size() > 0) {
            for (int i = 0; i < autoPauseTargets.size(); ++i) {
                ICanAutoPause target = autoPauseTargets.get(i);
                target.onAutoResume();
            }
        }
    }

    private static boolean pauseSvga(SVGAImageView svgaImageView) {
        Drawable drawable2;
        if (svgaImageView == null) {
            return false;
        }
        if (svgaImageView.isAnimating() && svgaImageView.getLoops() <= 0 && (drawable2 = svgaImageView.getDrawable()) instanceof SVGADrawable && !((SVGADrawable)drawable2).getCleared()) {
            svgaImageView.pauseAnimation();
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)"ImageAuto_SvgaAutoPause", (String)"pauseSvga:%s", (Object[])new Object[]{svgaImageView.toString()});
            }
            svgaImageView.setTag(R.id.yy_svga_auto_pause_id, (Object)true);
            return true;
        }
        return false;
    }

    private static void pauseAnimation(View view) {
        if (view == null) {
            return;
        }
        Animation animation = view.getAnimation();
        if (animation == null || animation.getRepeatCount() != -1) {
            return;
        }
        animation.cancel();
        view.setTag(R.id.yy_animation_auto_pause_id, (Object)true);
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)"ImageAuto_SvgaAutoPause", (String)"pauseAnimation: %s", (Object[])new Object[]{view.toString()});
        }
    }

    private static void resumeSvga(SVGAImageView svgaImageView) {
        Drawable drawable2;
        if (svgaImageView == null) {
            return;
        }
        Object restartTag = svgaImageView.getTag(R.id.yy_svga_auto_pause_id);
        if (restartTag instanceof Boolean && ((Boolean)restartTag).booleanValue() && svgaImageView.getVisibility() == 0 && !svgaImageView.isAnimating() && svgaImageView.getLoops() <= 0 && ViewCompat.isAttachedToWindow((View)svgaImageView) && (drawable2 = svgaImageView.getDrawable()) instanceof SVGADrawable && !((SVGADrawable)drawable2).getCleared()) {
            if (drawable2.isVisible() && ViewCompat.isAttachedToWindow((View)svgaImageView)) {
                svgaImageView.startAnimation();
            }
            svgaImageView.setTag(R.id.yy_svga_auto_pause_id, (Object)false);
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)"ImageAuto_SvgaAutoPause", (String)"resumeSvga:%s", (Object[])new Object[]{svgaImageView.toString()});
            }
        }
    }

    private static void resumeAnimation(View view) {
        if (view == null) {
            return;
        }
        Object tag = view.getTag(R.id.yy_animation_auto_pause_id);
        if (tag instanceof Boolean && ((Boolean)tag).booleanValue()) {
            Animation animation = view.getAnimation();
            if (animation == null || !ViewCompat.isAttachedToWindow((View)view)) {
                return;
            }
            if (view.getVisibility() == 0 && animation.getRepeatCount() == -1 && SvgaAutoPause.isAnimationCancel(animation)) {
                animation.reset();
                animation.start();
                view.setTag(R.id.yy_animation_auto_pause_id, (Object)false);
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)"ImageAuto_SvgaAutoPause", (String)"resumeAnimation: %s", (Object[])new Object[]{view.toString()});
                }
            }
        }
    }

    private static boolean closeRecovery() {
        return SystemUtils.isShowEnvSetting() && SettingFlags.getIntValue((String)"image_auto_recycle", (int)0) == 2;
    }

    private static boolean isAnimationCancel(@NonNull Animation animation) {
        return animation.getStartTime() == Long.MIN_VALUE;
    }

    public static void setRecoverInterceptor(IRecoverInterceptor recoverInterceptor) {
        sRecoverInterceptor = recoverInterceptor;
    }

    public static interface IRecoverInterceptor {
        public View getRecoverView(ViewGroup var1);
    }
}

