/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent;

import android.content.Context;
import android.os.SystemClock;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.IHttpRequestSender;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.unifyconfig.config.NetPreventDuplicateConfig;
import com.yy.appbase.unifyconfig.config.NetPreventDuplicateConfigItem;
import com.yy.appbase.util.FunctionReporter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent.HttpRequestPreventDuplicater;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HttpRequestPreventDuplicateUtil {
    private static final String TAG = "HttpRequestPreventDuplicateUtil";
    private static HashMap<String, HttpRequestPreventDuplicater> requestPreventDuplicaters;
    private static ArrayList<String> keys;
    private static INotify registerNotify;
    private static HttpRequestPreventDuplicater.ICallback sCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <Data> void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<Data> callback, Map<String, String> headDataToAdd, IHttpRequestSender sender) {
        if (url == null || url.contains("/ymicro/api")) {
            sender.httpReq(url, postContent, param, type2, callback, headDataToAdd);
            return;
        }
        if (!NetPreventDuplicateConfig.isNetPreventDuplicateSwitchOn((int)1)) {
            sender.httpReq(url, postContent, param, type2, callback, headDataToAdd);
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)TAG, (String)"httpReq NetPreventDuplicateSwitchOn is false!", (Object[])new Object[0]);
            }
            return;
        }
        HttpRequestPreventDuplicater duplicater = null;
        String key = HttpRequestPreventDuplicateUtil.getKey(url, type2, postContent, headDataToAdd);
        Class<HttpRequestPreventDuplicateUtil> clazz = HttpRequestPreventDuplicateUtil.class;
        synchronized (HttpRequestPreventDuplicateUtil.class) {
            if (requestPreventDuplicaters == null) {
                requestPreventDuplicaters = new HashMap(50);
                keys = new ArrayList(50);
            } else {
                duplicater = requestPreventDuplicaters.get(key);
            }
            if (sCallback == null) {
                HttpRequestPreventDuplicateUtil.initCallback();
            }
            if (duplicater == null) {
                duplicater = new HttpRequestPreventDuplicater(key, sCallback);
                requestPreventDuplicaters.put(key, duplicater);
            }
            if (key.contains("?")) {
                keys.add(key);
            }
            if (requestPreventDuplicaters.size() > 500 && keys.size() > 0) {
                requestPreventDuplicaters.remove(keys.get(0));
                keys.remove(0);
            }
            if (requestPreventDuplicaters.size() > 500 && SystemUtils.isShowEnvSetting()) {
                MLog.error((Object)TAG, (String)"requestPreventDuplicaters keys:%s", (Object[])new Object[]{requestPreventDuplicaters.keySet().toString()});
                throw new RuntimeException("HttpRequestPreventDuplicateUtil too many PreventDuplicaters!");
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            duplicater.httpReq(url, postContent, param, type2, callback, headDataToAdd, sender);
            return;
        }
    }

    private static void initCallback() {
        if (sCallback == null) {
            sCallback = new HttpRequestPreventDuplicater.ICallback(){

                @Override
                public long getCacheEffectiveTime(String url, Map<String, String> param, int type2, INetRespCallback callback, Map<String, String> headDataToAdd) {
                    if (url == null) {
                        return 0L;
                    }
                    NetPreventDuplicateConfigItem item = NetPreventDuplicateConfig.getItem((int)1, (String)url, (String)"", (String)"");
                    long result = -1L;
                    if (callback != null && callback.getCacheEffectiveTime() == Long.MIN_VALUE) {
                        if (SystemUtils.isShowEnvSetting()) {
                            MLog.info((Object)HttpRequestPreventDuplicateUtil.TAG, (String)"getCacheEffectiveTime:%s, result:%d", (Object[])new Object[]{url, result});
                        }
                        return 0L;
                    }
                    if (item != null) {
                        result = item.swtichOn ? (long)item.cacheEffectiveTime : 0L;
                    } else {
                        long l = result = callback != null ? callback.getCacheEffectiveTime() : 0L;
                    }
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info((Object)HttpRequestPreventDuplicateUtil.TAG, (String)"getCacheEffectiveTime:%s, result:%d", (Object[])new Object[]{url, result});
                    }
                    return result;
                }

                @Override
                public void onDuplicateRequest(boolean isRequesting, HttpRequestPreventDuplicater.HttpRequestBaseData request, int preventNum, int totalNum, int preventNumInCacheTime) {
                    if (request == null || request.url == null) {
                        if (request != null) {
                            MLog.info((Object)HttpRequestPreventDuplicateUtil.TAG, (String)"request.url is null!", (Object[])new Object[0]);
                        } else {
                            MLog.info((Object)HttpRequestPreventDuplicateUtil.TAG, (String)"request is null!", (Object[])new Object[0]);
                        }
                        return;
                    }
                    FunctionReporter.statFunctionWorked((String)"HttpRequestPrevent");
                    if (preventNumInCacheTime > 80 && !RuntimeContext.sIsAutoTesting && !TargetBuildConstant.auto_test && !TargetBuildConstant.autoLogin && SystemUtils.isShowEnvSetting()) {
                        throw new RuntimeException("maybe happen \u6b7b\u5faa\u73af\u8bf7\u6c42\uff0c\u77ed\u65f6\u95f4\u53d1\u9001\u4e8680\u6b21\u540c\u6837\u7684\u8bf7\u6c42:" + request.url);
                    }
                    if (preventNumInCacheTime > 80 && !SystemUtils.isShowEnvSetting() && request.url != null && NetworkUtils.getNetWarningCallback() != null) {
                        NetworkUtils.getNetWarningCallback().onRequestHighFrequency("Http", request.url);
                    }
                    if (!SystemUtils.isShowEnvSetting() && !NetPreventDuplicateConfig.isStatSwitchOn()) {
                        return;
                    }
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("ifield", isRequesting ? 1 : 0);
                    if (preventNumInCacheTime > 5) {
                        statContent.put("ifieldtwo", preventNumInCacheTime);
                    }
                    statContent.put("sfield", "http");
                    statContent.put("sfieldtwo", "prevent");
                    int index = request.url.indexOf("?");
                    if (index > 0) {
                        statContent.put("sfieldthree", request.url.substring(0, index));
                    } else {
                        statContent.put("sfieldthree", request.url);
                    }
                    statContent.put("sfieldfour", String.valueOf(AccountUtil.getUid()));
                    statContent.put("sfieldfive", RuntimeContext.getChannelId());
                    statContent.put("perftype", "net_prevent_duplicate");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }

                @Override
                public void maybeDuplicateRequest(HttpRequestPreventDuplicater preventDuplicater, HttpRequestPreventDuplicater.HttpRequestBaseData data, String url, byte[] postContent, Map<String, String> param, int type2, Map<String, String> headDataToAdd) {
                    if (url == null) {
                        return;
                    }
                    if (!SystemUtils.isShowEnvSetting() && !NetPreventDuplicateConfig.isStatSwitchOn()) {
                        return;
                    }
                    boolean statCalculationTime = NetPreventDuplicateConfig.isStatCalculationTimeSwitchOn();
                    long lastTime = statCalculationTime ? SystemClock.uptimeMillis() : 0L;
                    long curTime = 0L;
                    boolean isEqual = preventDuplicater.isRequestEqual(data, url, postContent, param, type2, headDataToAdd);
                    if (statCalculationTime) {
                        curTime = SystemClock.uptimeMillis();
                    }
                    if (isEqual) {
                        if (curTime == 0L) {
                            curTime = SystemClock.uptimeMillis();
                        }
                        long cachedTime = curTime - data.startTime;
                        StatisContent statContent = new StatisContent();
                        statContent.put("act", "hagoperf");
                        statContent.put("ifield", (int)cachedTime);
                        if (statCalculationTime) {
                            statContent.put("ifieldtwo", (int)(curTime - lastTime));
                        }
                        statContent.put("sfield", "http");
                        statContent.put("sfieldtwo", "maybeCanPrevent");
                        int index = url.indexOf("?");
                        if (index > 0) {
                            statContent.put("sfieldthree", url.substring(0, index));
                        } else {
                            statContent.put("sfieldthree", url);
                        }
                        statContent.put("sfieldfour", String.valueOf(AccountUtil.getUid()));
                        statContent.put("perftype", "net_prevent_duplicate");
                        HiidoStatis.reportContent((StatisContent)statContent);
                        if (SystemUtils.isShowEnvSetting()) {
                            MLog.info((Object)HttpRequestPreventDuplicateUtil.TAG, (String)"hit cache:0, uri:%s, cache is expired, cached timeLength:%d", (Object[])new Object[]{url, (int)cachedTime});
                        }
                    }
                }
            };
        }
    }

    private static String getKey(String url, int type2, byte[] postContent, Map<String, String> headDataToAdd) {
        StringBuilder stringBuilder = new StringBuilder(url);
        stringBuilder.append("+");
        stringBuilder.append(type2);
        stringBuilder.append("+");
        if (headDataToAdd != null) {
            stringBuilder.append(headDataToAdd.size());
        } else {
            stringBuilder.append("0");
        }
        return stringBuilder.toString();
    }

    public static void registerNotifys() {
        if (registerNotify == null) {
            registerNotify = new INotify(){

                public void notify(Notification notification) {
                    if (notification == null) {
                        return;
                    }
                    if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE) {
                        if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                            HttpRequestPreventDuplicateUtil.onNetConnected();
                        }
                    } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
                        HttpRequestPreventDuplicateUtil.onLoginOut();
                    } else if (notification.id == NotificationDef.N_ON_TRIM_MEMORY) {
                        HttpRequestPreventDuplicateUtil.onTrimMemory();
                    }
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, registerNotify);
                    NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, registerNotify);
                    NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, registerNotify);
                }
            });
        }
    }

    protected static void onNetConnected() {
        MLog.info((Object)TAG, (String)"onNetConnected!", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<HttpRequestPreventDuplicateUtil> clazz = HttpRequestPreventDuplicateUtil.class;
                synchronized (HttpRequestPreventDuplicateUtil.class) {
                    if (requestPreventDuplicaters == null || requestPreventDuplicaters.size() <= 0) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    Set keys = requestPreventDuplicaters.keySet();
                    for (String key : keys) {
                        HttpRequestPreventDuplicater item = (HttpRequestPreventDuplicater)requestPreventDuplicaters.get(key);
                        if (item == null) continue;
                        item.onNetConnected();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    protected static void onLoginOut() {
        MLog.info((Object)TAG, (String)"onLoginOut!", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<HttpRequestPreventDuplicateUtil> clazz = HttpRequestPreventDuplicateUtil.class;
                synchronized (HttpRequestPreventDuplicateUtil.class) {
                    if (requestPreventDuplicaters == null || requestPreventDuplicaters.size() <= 0) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    Set keys = requestPreventDuplicaters.keySet();
                    for (String key : keys) {
                        HttpRequestPreventDuplicater item = (HttpRequestPreventDuplicater)requestPreventDuplicaters.get(key);
                        if (item == null) continue;
                        item.onLoginOut();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    protected static void onTrimMemory() {
        MLog.info((Object)TAG, (String)"onTrimMemory!", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<HttpRequestPreventDuplicateUtil> clazz = HttpRequestPreventDuplicateUtil.class;
                synchronized (HttpRequestPreventDuplicateUtil.class) {
                    if (requestPreventDuplicaters == null || requestPreventDuplicaters.size() <= 0) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    long curTime = SystemClock.uptimeMillis();
                    Set keys = requestPreventDuplicaters.keySet();
                    for (String key : keys) {
                        HttpRequestPreventDuplicater item = (HttpRequestPreventDuplicater)requestPreventDuplicaters.get(key);
                        if (item == null) continue;
                        item.onTrimMemory(curTime);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

