/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.memorythread;

import android.app.Application;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.unifyconfig.config.data.ThreadOptConfig;
import com.yy.appbase.unifyconfig.config.data.ThreadOptConfigData;
import com.yy.appbase.util.FunctionReporter;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYProxyScheduledThreadPoolExecutor;
import com.yy.base.taskexecutor.YYProxyThreadPoolExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.taskexecutor.instrument.ThreadHookHelper;
import com.yy.base.taskexecutor.single.YYProxySingleScheduledExecutor;
import com.yy.base.taskexecutor.single.YYProxySingleThreadPoolExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class ThreadOpt {
    private static String TAG = "ThreadOpt";
    private static boolean sTestSwitchOn = true;
    private static boolean sHappenReplace = false;

    public static void onApplicationCreate(Application application) {
        ThreadOpt.doThreadOpt();
    }

    public static void doThreadOpt() {
        if (YYTaskExecutor.getThreadPriorityType() != -1) {
            return;
        }
        int threadPriorityType = SettingFlags.getIntValue((String)"thread_pool_type_new", (int)3);
        int threadPoolType = SettingFlags.getIntValue((String)"thread_pool_all_use_scheduled", (int)3);
        String debugKey = "thread_opt_debug_setting";
        if (SettingFlags.containKey((String)debugKey)) {
            MLog.info((Object)"ThreadOpt", (String)"use debug setting!", (Object[])new Object[0]);
            if (SettingFlags.getIntValue((String)debugKey, (int)1) == 1) {
                threadPriorityType = 3;
                threadPoolType = 3;
            } else if (SettingFlags.getIntValue((String)debugKey, (int)1) == 2) {
                threadPriorityType = 2;
                threadPoolType = 3;
            } else if (SettingFlags.getIntValue((String)debugKey, (int)1) == 3) {
                threadPriorityType = 2;
                threadPoolType = 2;
            }
        }
        MLog.info((Object)"ThreadOpt", (String)"priority type:%d, poolType:%d!", (Object[])new Object[]{threadPriorityType, threadPoolType});
        if (threadPriorityType < 1 || threadPriorityType > 3) {
            threadPriorityType = 3;
        }
        if (threadPoolType < 1 || threadPoolType > 3) {
            threadPoolType = 3;
        }
        YYTaskExecutor.setThreadOptType((int)threadPriorityType, (int)threadPoolType);
        ThreadOpt.test();
        ThreadOpt.initThreadHookSwticher();
    }

    private static boolean forceUseOur(String tag) {
        return false;
    }

    private static void happenThreadReplace() {
        sHappenReplace = true;
        FunctionReporter.statFunctionWorked((String)"ThreadHookWork");
    }

    private static void initThreadHookSwticher() {
        if (SystemUtils.isShowEnvSetting() && SettingFlags.getIntValue((String)"thread_opt_debug_hooker", (int)1) == 2) {
            return;
        }
        ThreadHookHelper.setThreadHookSwticher((ThreadHookHelper.IThreadHookSwitcher)new ThreadHookHelper.IThreadHookSwitcher(){

            public boolean shouldHookOneThread(String tag) {
                if (ThreadOpt.forceUseOur(tag)) {
                    MLog.info((Object)TAG, (String)"OneThread force use our thread:%s", (Object[])new Object[]{tag});
                    return true;
                }
                ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                if (data.oneThreadSwitch && data.getTagsUseOurThread().contains(tag)) {
                    MLog.info((Object)TAG, (String)"OneThread use our thread:%s", (Object[])new Object[]{tag});
                    return true;
                }
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)TAG, (String)"OneThread not use our thread:%s", (Object[])new Object[]{tag});
                    return false;
                }
                return false;
            }

            public boolean allowCoreThreadTimeOut() {
                ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                return data.allowCoreThreadTimeOut || SystemUtils.isShowEnvSetting();
            }

            public boolean needUseWorkPriorityPool(String tag) {
                return ThreadOpt.needUseWorkPriorityPool(tag, false);
            }

            public boolean shouldHookThreadPoolExecutor(String tag) {
                boolean forceUseOur = ThreadOpt.forceUseOur(tag);
                boolean useOurThread = forceUseOur;
                if (!useOurThread) {
                    ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                    if (data.normalThreadPoolSwitch && data.getTagsUseOurThread().contains(tag)) {
                        MLog.info((Object)TAG, (String)"newThreadPool use our thread:%s", (Object[])new Object[]{tag});
                        useOurThread = true;
                    }
                }
                return useOurThread;
            }

            public boolean shouldHookScheduledThreadPoolExecutor(String tag) {
                boolean forceUseOur = ThreadOpt.forceUseOur(tag);
                boolean useOurThread = forceUseOur;
                if (!useOurThread) {
                    ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                    if (data.scheduledThreadPoolSwitch && data.getTagsUseOurThread().contains(tag)) {
                        MLog.info((Object)TAG, (String)"newScheduledThreadPool use our thread:%s", (Object[])new Object[]{tag});
                        useOurThread = true;
                    }
                }
                return useOurThread;
            }

            public boolean shouldOneThreadUseHighPriority(String tag) {
                return ThreadOpt.needUseWorkPriorityPool(tag, false);
            }

            public ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory, String tag) {
                if (ThreadOpt.forceUseOur(tag)) {
                    MLog.info((Object)TAG, (String)"SingleThreadExecutor force use our thread:%s", (Object[])new Object[]{tag});
                    return new YYProxySingleThreadPoolExecutor(tag);
                }
                ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                if (data.singleThreadSwtich && data.getTagsUseOurThread().contains(tag)) {
                    MLog.info((Object)TAG, (String)"SingleThreadExecutor use our thread:%s", (Object[])new Object[]{tag});
                    return new YYProxySingleThreadPoolExecutor(tag);
                }
                MLog.info((Object)TAG, (String)"SingleThreadExecutor not use our thread:%s", (Object[])new Object[]{tag});
                return null;
            }

            public ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory, String tag) {
                if (ThreadOpt.forceUseOur(tag)) {
                    MLog.info((Object)TAG, (String)"SingleThreadScheduled force use our thread:%s", (Object[])new Object[]{tag});
                    return new YYProxySingleScheduledExecutor(threadFactory, tag);
                }
                ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                if (data.singleThreadScheduledSwitch && data.getTagsUseOurThread().contains(tag)) {
                    MLog.info((Object)TAG, (String)"SingleThreadScheduled use our thread:%s", (Object[])new Object[]{tag});
                    return new YYProxySingleScheduledExecutor(threadFactory, tag);
                }
                MLog.info((Object)TAG, (String)"SingleThreadScheduled not use our thread:%s", (Object[])new Object[]{tag});
                return null;
            }

            public ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory, String tag) {
                if (ThreadOpt.forceUseOur(tag)) {
                    ThreadOpt.happenThreadReplace();
                    MLog.info((Object)TAG, (String)"FixedThreadPool force use our thread:%s", (Object[])new Object[]{tag});
                    if (nThreads == 1) {
                        return new YYProxySingleThreadPoolExecutor(tag);
                    }
                    return new YYProxyThreadPoolExecutor(nThreads, tag);
                }
                ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                if (nThreads == 1) {
                    if (data.singleThreadSwtich && data.getTagsUseOurThread().contains(tag)) {
                        MLog.info((Object)TAG, (String)"FixedThreadPool use our thread:%s", (Object[])new Object[]{tag});
                        ThreadOpt.happenThreadReplace();
                        return new YYProxySingleThreadPoolExecutor(tag);
                    }
                } else if (data.normalThreadPoolSwitch && data.getTagsUseOurThread().contains(tag)) {
                    MLog.info((Object)TAG, (String)"FixedThreadPool use our thread:%s", (Object[])new Object[]{tag});
                    ThreadOpt.happenThreadReplace();
                    return new YYProxyThreadPoolExecutor(nThreads, tag);
                }
                MLog.info((Object)TAG, (String)"FixedThreadPool not use our thread:%s", (Object[])new Object[]{tag});
                return null;
            }

            public ExecutorService newCachedThreadPool(ThreadFactory threadFactory, String tag) {
                if (ThreadOpt.forceUseOur(tag)) {
                    MLog.info((Object)TAG, (String)"CachedThreadPool force use our thread:%s", (Object[])new Object[]{tag});
                    ThreadOpt.happenThreadReplace();
                    return new YYProxyThreadPoolExecutor(8, tag);
                }
                ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                if (data.normalThreadPoolSwitch && data.getTagsUseOurThread().contains(tag)) {
                    ThreadOpt.happenThreadReplace();
                    MLog.info((Object)TAG, (String)"CachedThreadPool use our thread:%s", (Object[])new Object[]{tag});
                    return new YYProxyThreadPoolExecutor(8, tag);
                }
                MLog.info((Object)TAG, (String)"CachedThreadPool not use our thread:%s", (Object[])new Object[]{tag});
                return null;
            }

            public ScheduledThreadPoolExecutor newScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler, String tag) {
                if (ThreadOpt.forceUseOur(tag)) {
                    MLog.info((Object)TAG, (String)"newScheduledThreadPool force use our thread:%s", (Object[])new Object[]{tag});
                    ThreadOpt.happenThreadReplace();
                    return new YYProxyScheduledThreadPoolExecutor(corePoolSize, threadFactory, handler, tag);
                }
                ThreadOptConfigData data = ThreadOptConfig.getThreadOptConfig();
                if (data.scheduledThreadPoolSwitch && data.getTagsUseOurThread().contains(tag)) {
                    MLog.info((Object)TAG, (String)"newScheduledThreadPool use our thread:%s", (Object[])new Object[]{tag});
                    ThreadOpt.happenThreadReplace();
                    return new YYProxyScheduledThreadPoolExecutor(corePoolSize, threadFactory, handler, tag);
                }
                MLog.info((Object)TAG, (String)"newScheduledThreadPool not use our thread:%s", (Object[])new Object[]{tag});
                return null;
            }
        });
    }

    public static boolean needUseWorkPriorityPool(String tag, boolean fromScheduledThreadPool) {
        return "com.rtc.thunder:thunderbolt-fullvideo".equals(tag);
    }

    public static void onStartUpFinishedAfterThreeSecond() {
        IAB value;
        if (SettingFlags.containKey((String)"thread_opt_abtest")) {
            SettingFlags.removeKey((String)"thread_opt_abtest");
        }
        if ((value = SettingFlags.containKey((String)"thread_pool_type_new") ? NewABDefine.THREAD_POOL_OPT.getTest() : NewABDefine.THREAD_POOL_OPT.getTestWithoutReport()) != null && value.isValid()) {
            if (NAB.A.equals((Object)value) || NAB.D.equals((Object)value)) {
                SettingFlags.setIntValue((String)"thread_pool_type_new", (int)1);
                SettingFlags.setIntValue((String)"thread_pool_all_use_scheduled", (int)1);
            } else if (NAB.B.equals((Object)value)) {
                SettingFlags.setIntValue((String)"thread_pool_type_new", (int)2);
                SettingFlags.setIntValue((String)"thread_pool_all_use_scheduled", (int)1);
            } else if (NAB.C.equals((Object)value) || NAB.E.equals((Object)value)) {
                SettingFlags.setIntValue((String)"thread_pool_type_new", (int)2);
                SettingFlags.setIntValue((String)"thread_pool_all_use_scheduled", (int)2);
            }
            MLog.info((Object)TAG, (String)"initAbValue threadPool type:%s", (Object[])new Object[]{value.getABValue()});
        } else {
            if (SystemUtils.isShowEnvSetting() && System.currentTimeMillis() % 2L == 0L) {
                SettingFlags.setIntValue((String)"thread_pool_type_new", (int)2);
                SettingFlags.setIntValue((String)"thread_pool_all_use_scheduled", (int)2);
            }
            MLog.info((Object)TAG, (String)"initAbValue invalid!", (Object[])new Object[0]);
        }
    }

    private static void test() {
        if (SystemUtils.isShowEnvSetting() && sTestSwitchOn) {
            Runnable testMainRemove = new Runnable(){

                @Override
                public void run() {
                    MLog.info((Object)"lllllllll", (String)"test Main thread to remove One!", (Object[])new Object[0]);
                    if (SystemUtils.isShowEnvSetting()) {
                        throw new RuntimeException("test main remove failed!");
                    }
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)testMainRemove, (long)5000L);
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)testMainRemove);
            final Runnable testMainRemove2 = new Runnable(){

                @Override
                public void run() {
                    MLog.info((Object)"lllllllll", (String)"test Main thread to remove Two!", (Object[])new Object[0]);
                    if (SystemUtils.isShowEnvSetting()) {
                        throw new RuntimeException("test main remove failed2!");
                    }
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)testMainRemove2, (long)5000L);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)testMainRemove2);
                }
            }, (long)500L);
        }
    }
}

