/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.global;

import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.ui.DefaultWindow;
import java.util.ArrayList;

public class WindowPathMonitor
implements DefaultWindow.IGlobalWindowMonitor {
    private final ArrayList<Item> mPathItems = new ArrayList();
    private volatile Item mCurItem;
    private IWindowPathMonitorCallBack mCallBack;

    public WindowPathMonitor(IWindowPathMonitorCallBack callBack) {
        this.mCallBack = callBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShown(DefaultWindow window) {
        if (window == null) {
            return;
        }
        if (this.mCurItem == null || !StringUtils.equal((String)this.mCurItem.windowName, (String)window.getName())) {
            this.mCurItem = new Item();
        }
        this.mCurItem.windowShowStartTime = System.currentTimeMillis();
        this.mCurItem.windowName = window.getName();
        ArrayList<Item> arrayList = this.mPathItems;
        synchronized (arrayList) {
            this.mPathItems.remove(this.mCurItem);
            this.mPathItems.add(this.mCurItem);
        }
        if (this.mCallBack != null) {
            this.mCallBack.onCurWindowChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printWindowSwtichProcess() {
        if (this.mPathItems.size() <= 0) {
            MLog.error((Object)"App Window switch process:", (String)"", (Object[])new Object[0]);
            return;
        }
        StringBuffer logStringBuffer = new StringBuffer("");
        ArrayList<Item> arrayList = this.mPathItems;
        synchronized (arrayList) {
            for (Item item : this.mPathItems) {
                logStringBuffer.append("\n");
                logStringBuffer.append(item.windowName);
                logStringBuffer.append("   ");
                logStringBuffer.append(CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd kk:mm:ss.SSS").format(item.windowShowStartTime));
            }
        }
        MLog.error((Object)"App Window switch process:", (String)logStringBuffer.toString(), (Object[])new Object[0]);
    }

    public String getCurWindow() {
        if (this.mCurItem != null) {
            return this.mCurItem.windowName;
        }
        return "";
    }

    public long getWindowShowStartTime() {
        if (this.mCurItem != null) {
            return this.mCurItem.windowShowStartTime;
        }
        return -1L;
    }

    public ArrayList<Item> getPathItems() {
        return new ArrayList<Item>(this.mPathItems);
    }

    public static interface IWindowPathMonitorCallBack {
        public void onCurWindowChanged();
    }

    public static class Item {
        public volatile String windowName;
        public volatile long windowShowStartTime;
    }
}

