/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.global;

import com.yy.appbase.data.GlobalPerItemBean;
import com.yy.appbase.http.dns.HTTPDnsUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.AbstractMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.IMonitorCallBack;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DnsMonitor
extends AbstractMonitor
implements HTTPDnsUtils.IHttpDnsMonitorCallBack {
    private IQueueTaskExecutor mTaskExecutor = YYTaskExecutor.createAQueueExcuter((boolean)false, (boolean)false);

    public DnsMonitor(IMonitorCallBack callBack) {
        super(callBack);
    }

    @Override
    public void start() {
        HTTPDnsUtils.INSTANCE.setDnsMonitorCallBack((HTTPDnsUtils.IHttpDnsMonitorCallBack)this);
    }

    @Override
    public void stop() {
        HTTPDnsUtils.INSTANCE.setDnsMonitorCallBack(null);
    }

    public void onMonitor(final String hostname, final int ips) {
        this.mTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                GlobalPerItemBean globalPItem = DnsMonitor.this.mCallBack.createBaseItem(5, 0, 0, hostname, false);
                if (ips > 0) {
                    globalPItem.result = 1;
                } else {
                    globalPItem.size = 1;
                }
                DnsMonitor.this.mCallBack.addPerItem(globalPItem);
                if (RuntimeContext.sIsDebuggable) {
                    HiidoStatis.reportAppMonitorReturnCode((String)("hyDns/" + hostname), (long)-1L, (String)(ips > 0 ? "0" : "1"));
                }
            }
        }, 0L);
    }

    public void onMonitor(final @NotNull Map<String, Integer> hostWithIp, final @NotNull Map<String, Integer> hostNoIp) {
        if (hostNoIp.isEmpty() && hostWithIp.isEmpty()) {
            return;
        }
        this.mTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                GlobalPerItemBean globalPItem;
                Set keys;
                if (!hostNoIp.isEmpty()) {
                    keys = hostNoIp.keySet();
                    for (String key : keys) {
                        if (StringUtils.isEmpty((String)key)) continue;
                        globalPItem = DnsMonitor.this.mCallBack.createBaseItem(5, 0, 0, key, false);
                        globalPItem.size = (Integer)hostNoIp.get(key);
                        DnsMonitor.this.mCallBack.addPerItem(globalPItem);
                    }
                }
                if (!hostWithIp.isEmpty()) {
                    keys = hostWithIp.keySet();
                    for (String key : keys) {
                        if (StringUtils.isEmpty((String)key)) continue;
                        globalPItem = DnsMonitor.this.mCallBack.createBaseItem(5, 0, 0, key, false);
                        globalPItem.result = (Integer)hostWithIp.get(key);
                        DnsMonitor.this.mCallBack.addPerItem(globalPItem);
                    }
                }
            }
        }, 0L);
    }
}

