/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.global;

import com.yy.appbase.data.GlobalPerItemBean;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.json.OnJsonParseMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.AbstractMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.IMonitorCallBack;

public class DataParserMonitor
extends AbstractMonitor
implements OnJsonParseMonitor {
    private static final String TAG = "PerfApm_DataParserMonitor";
    private static final String FORMAT = "isMainThread = %s %s";
    private static final boolean PRINT_CALL_STACK;
    private static final boolean ENABLE_LOG;
    private IQueueTaskExecutor mTaskExecutor = YYTaskExecutor.createAQueueExcuter((boolean)false, (boolean)false);

    public DataParserMonitor(IMonitorCallBack callBack) {
        super(callBack);
    }

    @Override
    public void start() {
        JsonParser.setOnJsonParseMonitor((SettingFlags.getBoolean((String)"global_data_parse_monitor", (boolean)false) || SystemUtils.isShowEnvSetting()) && this.mCallBack != null ? this : null);
    }

    @Override
    public void stop() {
        JsonParser.setOnJsonParseMonitor(null);
    }

    public void onParse(String parseType) {
        boolean isMainThread = this.reportReasonDesc(parseType);
        if (ENABLE_LOG) {
            if (!PRINT_CALL_STACK) {
                if (isMainThread) {
                    MLog.error((Object)TAG, (String)FORMAT, (Object[])new Object[]{true, parseType});
                } else {
                    MLog.info((Object)TAG, (String)FORMAT, (Object[])new Object[]{false, parseType});
                }
            } else {
                MLog.error((Object)TAG, (Throwable)new RuntimeException("isMainThread " + isMainThread + " " + parseType));
            }
        }
    }

    private boolean reportReasonDesc(final String desc) {
        final boolean isMainThread = YYTaskExecutor.isMainThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GlobalPerItemBean globalPItem = DataParserMonitor.this.mCallBack.createBaseItem(3, 0, 0, desc, isMainThread);
                DataParserMonitor.this.mCallBack.addPerItem(globalPItem);
            }
        };
        this.execute(runnable);
        if (!RuntimeContext.sIsDebuggable || isMainThread) {
            // empty if block
        }
        return isMainThread;
    }

    private void execute(Runnable runnable) {
        this.mTaskExecutor.execute(runnable, 0L);
    }

    static {
        if (SystemUtils.isShowEnvSetting()) {
            // empty if block
        }
        PRINT_CALL_STACK = false;
        ENABLE_LOG = SystemUtils.isShowEnvSetting();
    }
}

