/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.SharedPreferences;

import android.app.Application;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.config.taskopt.TaskOptConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesExecutor;
import com.yy.base.utils.SharedPreferencesImpl;
import com.yy.base.utils.SystemUtils;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collection;
import java.util.HashMap;

public class SharedPreferencesMonitor {
    private static boolean sNeedInterceptWriteAction = true;
    private static HashMap<SharedPreferencesImpl, MyRunnable> delayCommandAfterStarupFinish = new HashMap(10);

    public static void onPerConfigUpdated() {
        if (!SettingFlags.getBoolean((String)"keysharepref_monitor", (boolean)true)) {
            SharedPreferencesImpl.setSharedPreferencesMonitor(null);
        }
    }

    public static void initSharedPreferencesMonitor() {
        int oneM = 0x100000;
        if (SettingFlags.getBoolean((String)"keysharepref_monitor", (boolean)true)) {
            SharedPreferencesImpl.setSharedPreferencesMonitor((SharedPreferencesImpl.ISharedPreferencesMonitor)new SharedPreferencesImpl.ISharedPreferencesMonitor(){

                public int onBeforeLoadFile(String fileName, long fileSize) {
                    if (fileSize >= 0x200000L && fileName != null) {
                        if (fileName.contains("ARGO_PREFRENCE")) {
                            HiidoStatis.reportReturnCode((String)"ARGO_PREFRENCE", (long)fileSize, (String)"0");
                            return 1;
                        }
                        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
                            HiidoStatis.reportReturnCode((String)("prefrence/" + fileName), (long)fileSize, (String)"0");
                        }
                    }
                    return 0;
                }

                public int afterLoadFile(String fileName, int mapSize) {
                    return 0;
                }

                public int afterModify(String fileName, int mapSize) {
                    if (fileName != null && fileName.contains("ARGO_PREFRENCE") && mapSize > 50) {
                        return 2;
                    }
                    return 0;
                }
            });
        }
    }

    public static void onApplicationCreate(Application application) {
        if (YYTaskExecutor.getThreadPriorityType() == 2 && (SystemUtils.isShowEnvSetting() || SettingFlags.getBoolean((String)"keyUseExecutorNew2", (boolean)true))) {
            SharedPreferencesImpl.setSharedPreferencesExecutor((SharedPreferencesExecutor)new SharedPreferencesExecutor());
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SharedPreferencesMonitor.handleDelayCommand();
            }
        }, (long)15000L);
        SharedPreferencesImpl.setSharedPreferencesOpt((SharedPreferencesImpl.ISharedSavePreferencesOpt)new SharedPreferencesImpl.ISharedSavePreferencesOpt(){

            public boolean useWriteFrequencyLimit() {
                return SystemUtils.isShowEnvSetting() || TaskOptConfig.getSharedPrefWriteTime() > 0;
            }

            public long getFrequencyLimitTimeLength() {
                if (SystemUtils.isShowEnvSetting()) {
                    return 1000L;
                }
                return TaskOptConfig.getSharedPrefWriteTime() > 0 ? (long)TaskOptConfig.getSharedPrefWriteTime() : 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean shouleInterceptWriteAction(SharedPreferencesImpl item, Runnable writeAction, boolean apply) {
                if (!RuntimeContext.sIsMainProcess || AccountUtil.getUid() <= 0L || !sNeedInterceptWriteAction) {
                    HashMap hashMap = delayCommandAfterStarupFinish;
                    synchronized (hashMap) {
                        delayCommandAfterStarupFinish.remove(item);
                    }
                    return false;
                }
                if (!SystemUtils.isShowEnvSetting() && !TaskOptConfig.isSharedPrefSwitch()) {
                    HashMap hashMap = delayCommandAfterStarupFinish;
                    synchronized (hashMap) {
                        delayCommandAfterStarupFinish.remove(item);
                    }
                    return false;
                }
                if (RuntimeContext.getPhoneType() == 3 && !RuntimeContext.sIsAppStartFinishAfterOneSecond || RuntimeContext.getPhoneType() != 3 && !RuntimeContext.sIsAppStartFinishAfterThreeSecond) {
                    HashMap hashMap = delayCommandAfterStarupFinish;
                    synchronized (hashMap) {
                        delayCommandAfterStarupFinish.put(item, new MyRunnable(writeAction, item.getFilePath()));
                    }
                    return true;
                }
                HashMap hashMap = delayCommandAfterStarupFinish;
                synchronized (hashMap) {
                    delayCommandAfterStarupFinish.remove(item);
                }
                return false;
            }

            public void onSaved(SharedPreferencesImpl item, boolean apply) {
            }
        });
    }

    public static void onStarupFinish() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SharedPreferencesMonitor.handleDelayCommand();
            }
        }, (long)(RuntimeContext.getPhoneType() != 3 && !RuntimeContext.sIsAppStartFinishAfterThreeSecond ? 2000L : 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleDelayCommand() {
        HashMap<SharedPreferencesImpl, MyRunnable> hashMap = delayCommandAfterStarupFinish;
        synchronized (hashMap) {
            Collection<MyRunnable> values = delayCommandAfterStarupFinish.values();
            for (MyRunnable value : values) {
                value.orgin.run();
                if (!SystemUtils.isShowEnvSetting()) continue;
                MLog.info((Object)"SharedPreferencesMonitor", (String)"delay write:%s", (Object[])new Object[]{value.tag});
            }
            delayCommandAfterStarupFinish.clear();
        }
        sNeedInterceptWriteAction = false;
    }

    private static class MyRunnable {
        Runnable orgin;
        String tag;

        public MyRunnable(Runnable runnable, String tag) {
            this.orgin = runnable;
            this.tag = tag;
        }
    }
}

